<?php

namespace fk_\EnumType;

/**
 * This class stands for EntityReadState EnumType
 * @subpackage Enumerations
 */
class EntityReadState
{
    /**
     * Constant for value 'NotReaded'
     * @return string 'NotReaded'
     */
    const VALUE_NOT_READED = 'NotReaded';
    /**
     * Constant for value 'DescriptionOnly'
     * @return string 'DescriptionOnly'
     */
    const VALUE_DESCRIPTION_ONLY = 'DescriptionOnly';
    /**
     * Constant for value 'EntityOnly'
     * @return string 'EntityOnly'
     */
    const VALUE_ENTITY_ONLY = 'EntityOnly';
    /**
     * Constant for value 'EntityWithDescription'
     * @return string 'EntityWithDescription'
     */
    const VALUE_ENTITY_WITH_DESCRIPTION = 'EntityWithDescription';
    /**
     * Constant for value 'DontRead'
     * @return string 'DontRead'
     */
    const VALUE_DONT_READ = 'DontRead';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NOT_READED
     * @uses self::VALUE_DESCRIPTION_ONLY
     * @uses self::VALUE_ENTITY_ONLY
     * @uses self::VALUE_ENTITY_WITH_DESCRIPTION
     * @uses self::VALUE_DONT_READ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NOT_READED,
            self::VALUE_DESCRIPTION_ONLY,
            self::VALUE_ENTITY_ONLY,
            self::VALUE_ENTITY_WITH_DESCRIPTION,
            self::VALUE_DONT_READ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
