<?php

namespace fk_\EnumType;

/**
 * This class stands for EArsivGonderimTuru EnumType
 * @subpackage Enumerations
 */
class EArsivGonderimTuru
{
    /**
     * Constant for value 'KAGIT'
     * @return string 'KAGIT'
     */
    const VALUE_KAGIT = 'KAGIT';
    /**
     * Constant for value 'ELEKTRONIK'
     * @return string 'ELEKTRONIK'
     */
    const VALUE_ELEKTRONIK = 'ELEKTRONIK';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KAGIT
     * @uses self::VALUE_ELEKTRONIK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KAGIT,
            self::VALUE_ELEKTRONIK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
