<?php

namespace fk_\EnumType;

/**
 * This class stands for KGunler EnumType
 * @subpackage Enumerations
 */
class KGunler
{
    /**
     * Constant for value 'Pazartesi'
     * @return string 'Pazartesi'
     */
    const VALUE_PAZARTESI = 'Pazartesi';
    /**
     * Constant for value 'Sali'
     * @return string 'Sali'
     */
    const VALUE_SALI = 'Sali';
    /**
     * Constant for value 'Carsamba'
     * @return string 'Carsamba'
     */
    const VALUE_CARSAMBA = 'Carsamba';
    /**
     * Constant for value 'Persembe'
     * @return string 'Persembe'
     */
    const VALUE_PERSEMBE = 'Persembe';
    /**
     * Constant for value 'Cuma'
     * @return string 'Cuma'
     */
    const VALUE_CUMA = 'Cuma';
    /**
     * Constant for value 'Cumartesi'
     * @return string 'Cumartesi'
     */
    const VALUE_CUMARTESI = 'Cumartesi';
    /**
     * Constant for value 'Pazar'
     * @return string 'Pazar'
     */
    const VALUE_PAZAR = 'Pazar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PAZARTESI
     * @uses self::VALUE_SALI
     * @uses self::VALUE_CARSAMBA
     * @uses self::VALUE_PERSEMBE
     * @uses self::VALUE_CUMA
     * @uses self::VALUE_CUMARTESI
     * @uses self::VALUE_PAZAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PAZARTESI,
            self::VALUE_SALI,
            self::VALUE_CARSAMBA,
            self::VALUE_PERSEMBE,
            self::VALUE_CUMA,
            self::VALUE_CUMARTESI,
            self::VALUE_PAZAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
