<?php

namespace fk_\EnumType;

/**
 * This class stands for CariHesapTuru EnumType
 * @subpackage Enumerations
 */
class CariHesapTuru
{
    /**
     * Constant for value 'Tuzel'
     * @return string 'Tuzel'
     */
    const VALUE_TUZEL = 'Tuzel';
    /**
     * Constant for value 'Gercek'
     * @return string 'Gercek'
     */
    const VALUE_GERCEK = 'Gercek';
    /**
     * Constant for value 'VergidenMuaf'
     * @return string 'VergidenMuaf'
     */
    const VALUE_VERGIDEN_MUAF = 'VergidenMuaf';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TUZEL
     * @uses self::VALUE_GERCEK
     * @uses self::VALUE_VERGIDEN_MUAF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TUZEL,
            self::VALUE_GERCEK,
            self::VALUE_VERGIDEN_MUAF,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
