<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSurucu StructType
 * @subpackage Structs
 */
class KSurucu extends Entity
{
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Durum;
    /**
     * The DogumYili
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DogumYili;
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ad;
    /**
     * The EhliyetNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EhliyetNo;
    /**
     * The EhliyetAldigiYer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EhliyetAldigiYer;
    /**
     * The EhliyetSinif
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EhliyetSinif;
    /**
     * The SurucuBelgeNumarasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurucuBelgeNumarasi;
    /**
     * The SurucuPersonelSicilNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SurucuPersonelSicilNo;
    /**
     * The CalismaArac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAracKaraPointer
     */
    public $CalismaArac;
    /**
     * The CalismaHat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KHatPointer
     */
    public $CalismaHat;
    /**
     * The CalismaSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $CalismaSube;
    /**
     * The Adres
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAdresPointer
     */
    public $Adres;
    /**
     * The CepTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CepTel;
    /**
     * The EvTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvTel;
    /**
     * The SonHareket
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSurucuHareketPointer
     */
    public $SonHareket;
    /**
     * The PersonelResim
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PersonelResim;
    /**
     * The TcKimlikNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TcKimlikNo;
    /**
     * Constructor method for KSurucu
     * @uses KSurucu::setDurum()
     * @uses KSurucu::setDogumYili()
     * @uses KSurucu::setAd()
     * @uses KSurucu::setEhliyetNo()
     * @uses KSurucu::setEhliyetAldigiYer()
     * @uses KSurucu::setEhliyetSinif()
     * @uses KSurucu::setSurucuBelgeNumarasi()
     * @uses KSurucu::setSurucuPersonelSicilNo()
     * @uses KSurucu::setCalismaArac()
     * @uses KSurucu::setCalismaHat()
     * @uses KSurucu::setCalismaSube()
     * @uses KSurucu::setAdres()
     * @uses KSurucu::setCepTel()
     * @uses KSurucu::setEvTel()
     * @uses KSurucu::setSonHareket()
     * @uses KSurucu::setPersonelResim()
     * @uses KSurucu::setTcKimlikNo()
     * @param string $durum
     * @param int $dogumYili
     * @param string $ad
     * @param string $ehliyetNo
     * @param string $ehliyetAldigiYer
     * @param string $ehliyetSinif
     * @param string $surucuBelgeNumarasi
     * @param string $surucuPersonelSicilNo
     * @param \fk_\StructType\KAracKaraPointer $calismaArac
     * @param \fk_\StructType\KHatPointer $calismaHat
     * @param \fk_\StructType\KSubePointer $calismaSube
     * @param \fk_\StructType\KAdresPointer $adres
     * @param string $cepTel
     * @param string $evTel
     * @param \fk_\StructType\KSurucuHareketPointer $sonHareket
     * @param string $personelResim
     * @param string $tcKimlikNo
     */
    public function __construct($durum = null, $dogumYili = null, $ad = null, $ehliyetNo = null, $ehliyetAldigiYer = null, $ehliyetSinif = null, $surucuBelgeNumarasi = null, $surucuPersonelSicilNo = null, \fk_\StructType\KAracKaraPointer $calismaArac = null, \fk_\StructType\KHatPointer $calismaHat = null, \fk_\StructType\KSubePointer $calismaSube = null, \fk_\StructType\KAdresPointer $adres = null, $cepTel = null, $evTel = null, \fk_\StructType\KSurucuHareketPointer $sonHareket = null, $personelResim = null, $tcKimlikNo = null)
    {
        $this
            ->setDurum($durum)
            ->setDogumYili($dogumYili)
            ->setAd($ad)
            ->setEhliyetNo($ehliyetNo)
            ->setEhliyetAldigiYer($ehliyetAldigiYer)
            ->setEhliyetSinif($ehliyetSinif)
            ->setSurucuBelgeNumarasi($surucuBelgeNumarasi)
            ->setSurucuPersonelSicilNo($surucuPersonelSicilNo)
            ->setCalismaArac($calismaArac)
            ->setCalismaHat($calismaHat)
            ->setCalismaSube($calismaSube)
            ->setAdres($adres)
            ->setCepTel($cepTel)
            ->setEvTel($evTel)
            ->setSonHareket($sonHareket)
            ->setPersonelResim($personelResim)
            ->setTcKimlikNo($tcKimlikNo);
    }
    /**
     * Get Durum value
     * @return string
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \fk_\EnumType\KSurucuDurum::valueIsValid()
     * @uses \fk_\EnumType\KSurucuDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \fk_\StructType\KSurucu
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KSurucuDurum::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KSurucuDurum', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \fk_\EnumType\KSurucuDurum::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get DogumYili value
     * @return int
     */
    public function getDogumYili()
    {
        return $this->DogumYili;
    }
    /**
     * Set DogumYili value
     * @param int $dogumYili
     * @return \fk_\StructType\KSurucu
     */
    public function setDogumYili($dogumYili = null)
    {
        // validation for constraint: int
        if (!is_null($dogumYili) && !(is_int($dogumYili) || ctype_digit($dogumYili))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dogumYili, true), gettype($dogumYili)), __LINE__);
        }
        $this->DogumYili = $dogumYili;
        return $this;
    }
    /**
     * Get Ad value
     * @return string|null
     */
    public function getAd()
    {
        return $this->Ad;
    }
    /**
     * Set Ad value
     * @param string $ad
     * @return \fk_\StructType\KSurucu
     */
    public function setAd($ad = null)
    {
        // validation for constraint: string
        if (!is_null($ad) && !is_string($ad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad, true), gettype($ad)), __LINE__);
        }
        $this->Ad = $ad;
        return $this;
    }
    /**
     * Get EhliyetNo value
     * @return string|null
     */
    public function getEhliyetNo()
    {
        return $this->EhliyetNo;
    }
    /**
     * Set EhliyetNo value
     * @param string $ehliyetNo
     * @return \fk_\StructType\KSurucu
     */
    public function setEhliyetNo($ehliyetNo = null)
    {
        // validation for constraint: string
        if (!is_null($ehliyetNo) && !is_string($ehliyetNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ehliyetNo, true), gettype($ehliyetNo)), __LINE__);
        }
        $this->EhliyetNo = $ehliyetNo;
        return $this;
    }
    /**
     * Get EhliyetAldigiYer value
     * @return string|null
     */
    public function getEhliyetAldigiYer()
    {
        return $this->EhliyetAldigiYer;
    }
    /**
     * Set EhliyetAldigiYer value
     * @param string $ehliyetAldigiYer
     * @return \fk_\StructType\KSurucu
     */
    public function setEhliyetAldigiYer($ehliyetAldigiYer = null)
    {
        // validation for constraint: string
        if (!is_null($ehliyetAldigiYer) && !is_string($ehliyetAldigiYer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ehliyetAldigiYer, true), gettype($ehliyetAldigiYer)), __LINE__);
        }
        $this->EhliyetAldigiYer = $ehliyetAldigiYer;
        return $this;
    }
    /**
     * Get EhliyetSinif value
     * @return string|null
     */
    public function getEhliyetSinif()
    {
        return $this->EhliyetSinif;
    }
    /**
     * Set EhliyetSinif value
     * @param string $ehliyetSinif
     * @return \fk_\StructType\KSurucu
     */
    public function setEhliyetSinif($ehliyetSinif = null)
    {
        // validation for constraint: string
        if (!is_null($ehliyetSinif) && !is_string($ehliyetSinif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ehliyetSinif, true), gettype($ehliyetSinif)), __LINE__);
        }
        $this->EhliyetSinif = $ehliyetSinif;
        return $this;
    }
    /**
     * Get SurucuBelgeNumarasi value
     * @return string|null
     */
    public function getSurucuBelgeNumarasi()
    {
        return $this->SurucuBelgeNumarasi;
    }
    /**
     * Set SurucuBelgeNumarasi value
     * @param string $surucuBelgeNumarasi
     * @return \fk_\StructType\KSurucu
     */
    public function setSurucuBelgeNumarasi($surucuBelgeNumarasi = null)
    {
        // validation for constraint: string
        if (!is_null($surucuBelgeNumarasi) && !is_string($surucuBelgeNumarasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surucuBelgeNumarasi, true), gettype($surucuBelgeNumarasi)), __LINE__);
        }
        $this->SurucuBelgeNumarasi = $surucuBelgeNumarasi;
        return $this;
    }
    /**
     * Get SurucuPersonelSicilNo value
     * @return string|null
     */
    public function getSurucuPersonelSicilNo()
    {
        return $this->SurucuPersonelSicilNo;
    }
    /**
     * Set SurucuPersonelSicilNo value
     * @param string $surucuPersonelSicilNo
     * @return \fk_\StructType\KSurucu
     */
    public function setSurucuPersonelSicilNo($surucuPersonelSicilNo = null)
    {
        // validation for constraint: string
        if (!is_null($surucuPersonelSicilNo) && !is_string($surucuPersonelSicilNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surucuPersonelSicilNo, true), gettype($surucuPersonelSicilNo)), __LINE__);
        }
        $this->SurucuPersonelSicilNo = $surucuPersonelSicilNo;
        return $this;
    }
    /**
     * Get CalismaArac value
     * @return \fk_\StructType\KAracKaraPointer|null
     */
    public function getCalismaArac()
    {
        return $this->CalismaArac;
    }
    /**
     * Set CalismaArac value
     * @param \fk_\StructType\KAracKaraPointer $calismaArac
     * @return \fk_\StructType\KSurucu
     */
    public function setCalismaArac(\fk_\StructType\KAracKaraPointer $calismaArac = null)
    {
        $this->CalismaArac = $calismaArac;
        return $this;
    }
    /**
     * Get CalismaHat value
     * @return \fk_\StructType\KHatPointer|null
     */
    public function getCalismaHat()
    {
        return $this->CalismaHat;
    }
    /**
     * Set CalismaHat value
     * @param \fk_\StructType\KHatPointer $calismaHat
     * @return \fk_\StructType\KSurucu
     */
    public function setCalismaHat(\fk_\StructType\KHatPointer $calismaHat = null)
    {
        $this->CalismaHat = $calismaHat;
        return $this;
    }
    /**
     * Get CalismaSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getCalismaSube()
    {
        return $this->CalismaSube;
    }
    /**
     * Set CalismaSube value
     * @param \fk_\StructType\KSubePointer $calismaSube
     * @return \fk_\StructType\KSurucu
     */
    public function setCalismaSube(\fk_\StructType\KSubePointer $calismaSube = null)
    {
        $this->CalismaSube = $calismaSube;
        return $this;
    }
    /**
     * Get Adres value
     * @return \fk_\StructType\KAdresPointer|null
     */
    public function getAdres()
    {
        return $this->Adres;
    }
    /**
     * Set Adres value
     * @param \fk_\StructType\KAdresPointer $adres
     * @return \fk_\StructType\KSurucu
     */
    public function setAdres(\fk_\StructType\KAdresPointer $adres = null)
    {
        $this->Adres = $adres;
        return $this;
    }
    /**
     * Get CepTel value
     * @return string|null
     */
    public function getCepTel()
    {
        return $this->CepTel;
    }
    /**
     * Set CepTel value
     * @param string $cepTel
     * @return \fk_\StructType\KSurucu
     */
    public function setCepTel($cepTel = null)
    {
        // validation for constraint: string
        if (!is_null($cepTel) && !is_string($cepTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cepTel, true), gettype($cepTel)), __LINE__);
        }
        $this->CepTel = $cepTel;
        return $this;
    }
    /**
     * Get EvTel value
     * @return string|null
     */
    public function getEvTel()
    {
        return $this->EvTel;
    }
    /**
     * Set EvTel value
     * @param string $evTel
     * @return \fk_\StructType\KSurucu
     */
    public function setEvTel($evTel = null)
    {
        // validation for constraint: string
        if (!is_null($evTel) && !is_string($evTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evTel, true), gettype($evTel)), __LINE__);
        }
        $this->EvTel = $evTel;
        return $this;
    }
    /**
     * Get SonHareket value
     * @return \fk_\StructType\KSurucuHareketPointer|null
     */
    public function getSonHareket()
    {
        return $this->SonHareket;
    }
    /**
     * Set SonHareket value
     * @param \fk_\StructType\KSurucuHareketPointer $sonHareket
     * @return \fk_\StructType\KSurucu
     */
    public function setSonHareket(\fk_\StructType\KSurucuHareketPointer $sonHareket = null)
    {
        $this->SonHareket = $sonHareket;
        return $this;
    }
    /**
     * Get PersonelResim value
     * @return string|null
     */
    public function getPersonelResim()
    {
        return $this->PersonelResim;
    }
    /**
     * Set PersonelResim value
     * @param string $personelResim
     * @return \fk_\StructType\KSurucu
     */
    public function setPersonelResim($personelResim = null)
    {
        // validation for constraint: string
        if (!is_null($personelResim) && !is_string($personelResim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($personelResim, true), gettype($personelResim)), __LINE__);
        }
        $this->PersonelResim = $personelResim;
        return $this;
    }
    /**
     * Get TcKimlikNo value
     * @return string|null
     */
    public function getTcKimlikNo()
    {
        return $this->TcKimlikNo;
    }
    /**
     * Set TcKimlikNo value
     * @param string $tcKimlikNo
     * @return \fk_\StructType\KSurucu
     */
    public function setTcKimlikNo($tcKimlikNo = null)
    {
        // validation for constraint: string
        if (!is_null($tcKimlikNo) && !is_string($tcKimlikNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tcKimlikNo, true), gettype($tcKimlikNo)), __LINE__);
        }
        $this->TcKimlikNo = $tcKimlikNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KSurucu
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
