<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSevkAdres StructType
 * @subpackage Structs
 */
class KSevkAdres extends Entity
{
    /**
     * The Tipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tipi;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAdresPointer
     */
    public $Adresi;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The Carisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $Carisi;
    /**
     * The DagitimSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $DagitimSube;
    /**
     * Constructor method for KSevkAdres
     * @uses KSevkAdres::setTipi()
     * @uses KSevkAdres::setAdresi()
     * @uses KSevkAdres::setAdi()
     * @uses KSevkAdres::setAciklama()
     * @uses KSevkAdres::setCarisi()
     * @uses KSevkAdres::setDagitimSube()
     * @param string $tipi
     * @param \fk_\StructType\KAdresPointer $adresi
     * @param string $adi
     * @param string $aciklama
     * @param \fk_\StructType\KCariPointer $carisi
     * @param \fk_\StructType\KSubePointer $dagitimSube
     */
    public function __construct($tipi = null, \fk_\StructType\KAdresPointer $adresi = null, $adi = null, $aciklama = null, \fk_\StructType\KCariPointer $carisi = null, \fk_\StructType\KSubePointer $dagitimSube = null)
    {
        $this
            ->setTipi($tipi)
            ->setAdresi($adresi)
            ->setAdi($adi)
            ->setAciklama($aciklama)
            ->setCarisi($carisi)
            ->setDagitimSube($dagitimSube);
    }
    /**
     * Get Tipi value
     * @return string
     */
    public function getTipi()
    {
        return $this->Tipi;
    }
    /**
     * Set Tipi value
     * @uses \fk_\EnumType\SevkAdresTip::valueIsValid()
     * @uses \fk_\EnumType\SevkAdresTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipi
     * @return \fk_\StructType\KSevkAdres
     */
    public function setTipi($tipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\SevkAdresTip::valueIsValid($tipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\SevkAdresTip', is_array($tipi) ? implode(', ', $tipi) : var_export($tipi, true), implode(', ', \fk_\EnumType\SevkAdresTip::getValidValues())), __LINE__);
        }
        $this->Tipi = $tipi;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \fk_\StructType\KAdresPointer|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \fk_\StructType\KAdresPointer $adresi
     * @return \fk_\StructType\KSevkAdres
     */
    public function setAdresi(\fk_\StructType\KAdresPointer $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\KSevkAdres
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\KSevkAdres
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get Carisi value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getCarisi()
    {
        return $this->Carisi;
    }
    /**
     * Set Carisi value
     * @param \fk_\StructType\KCariPointer $carisi
     * @return \fk_\StructType\KSevkAdres
     */
    public function setCarisi(\fk_\StructType\KCariPointer $carisi = null)
    {
        $this->Carisi = $carisi;
        return $this;
    }
    /**
     * Get DagitimSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getDagitimSube()
    {
        return $this->DagitimSube;
    }
    /**
     * Set DagitimSube value
     * @param \fk_\StructType\KSubePointer $dagitimSube
     * @return \fk_\StructType\KSevkAdres
     */
    public function setDagitimSube(\fk_\StructType\KSubePointer $dagitimSube = null)
    {
        $this->DagitimSube = $dagitimSube;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KSevkAdres
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
