<?php

namespace fk_\EnumType;

/**
 * This class stands for KTeslimatDurum EnumType
 * @subpackage Enumerations
 */
class KTeslimatDurum
{
    /**
     * Constant for value 'TeslimatHazirlik'
     * @return string 'TeslimatHazirlik'
     */
    const VALUE_TESLIMAT_HAZIRLIK = 'TeslimatHazirlik';
    /**
     * Constant for value 'TeslimEdildi'
     * @return string 'TeslimEdildi'
     */
    const VALUE_TESLIM_EDILDI = 'TeslimEdildi';
    /**
     * Constant for value 'IadeEdilecek'
     * @return string 'IadeEdilecek'
     */
    const VALUE_IADE_EDILECEK = 'IadeEdilecek';
    /**
     * Constant for value 'Yonlendirilecek'
     * @return string 'Yonlendirilecek'
     */
    const VALUE_YONLENDIRILECEK = 'Yonlendirilecek';
    /**
     * Constant for value 'Devir'
     * @return string 'Devir'
     */
    const VALUE_DEVIR = 'Devir';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TESLIMAT_HAZIRLIK
     * @uses self::VALUE_TESLIM_EDILDI
     * @uses self::VALUE_IADE_EDILECEK
     * @uses self::VALUE_YONLENDIRILECEK
     * @uses self::VALUE_DEVIR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TESLIMAT_HAZIRLIK,
            self::VALUE_TESLIM_EDILDI,
            self::VALUE_IADE_EDILECEK,
            self::VALUE_YONLENDIRILECEK,
            self::VALUE_DEVIR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
