<?php

namespace fk_\EnumType;

/**
 * This class stands for IzinVerenBirim EnumType
 * @subpackage Enumerations
 */
class IzinVerenBirim
{
    /**
     * Constant for value 'Hepsi'
     * @return string 'Hepsi'
     */
    const VALUE_HEPSI = 'Hepsi';
    /**
     * Constant for value 'SUBE_KULLANICI'
     * @return string 'SUBE_KULLANICI'
     */
    const VALUE_SUBE_KULLANICI = 'SUBE_KULLANICI';
    /**
     * Constant for value 'BOLGE_PAZARLAMA'
     * @return string 'BOLGE_PAZARLAMA'
     */
    const VALUE_BOLGE_PAZARLAMA = 'BOLGE_PAZARLAMA';
    /**
     * Constant for value 'BOLGE_MUDURU'
     * @return string 'BOLGE_MUDURU'
     */
    const VALUE_BOLGE_MUDURU = 'BOLGE_MUDURU';
    /**
     * Constant for value 'ANALIZ_MUH'
     * @return string 'ANALIZ_MUH'
     */
    const VALUE_ANALIZ_MUH = 'ANALIZ_MUH';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HEPSI
     * @uses self::VALUE_SUBE_KULLANICI
     * @uses self::VALUE_BOLGE_PAZARLAMA
     * @uses self::VALUE_BOLGE_MUDURU
     * @uses self::VALUE_ANALIZ_MUH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HEPSI,
            self::VALUE_SUBE_KULLANICI,
            self::VALUE_BOLGE_PAZARLAMA,
            self::VALUE_BOLGE_MUDURU,
            self::VALUE_ANALIZ_MUH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
