<?php

namespace fk_\EnumType;

/**
 * This class stands for KEvrakFiyatHasaplamaSekli EnumType
 * @subpackage Enumerations
 */
class KEvrakFiyatHasaplamaSekli
{
    /**
     * Constant for value 'Sozlesmeyle'
     * @return string 'Sozlesmeyle'
     */
    const VALUE_SOZLESMEYLE = 'Sozlesmeyle';
    /**
     * Constant for value 'Serbest'
     * @return string 'Serbest'
     */
    const VALUE_SERBEST = 'Serbest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SOZLESMEYLE
     * @uses self::VALUE_SERBEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SOZLESMEYLE,
            self::VALUE_SERBEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
