<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracSozlesmeTur EnumType
 * @subpackage Enumerations
 */
class KAracSozlesmeTur
{
    /**
     * Constant for value 'Sureli'
     * @return string 'Sureli'
     */
    const VALUE_SURELI = 'Sureli';
    /**
     * Constant for value 'Munferit'
     * @return string 'Munferit'
     */
    const VALUE_MUNFERIT = 'Munferit';
    /**
     * Constant for value 'Ozmal'
     * @return string 'Ozmal'
     */
    const VALUE_OZMAL = 'Ozmal';
    /**
     * Constant for value 'UzunDonem'
     * @return string 'UzunDonem'
     */
    const VALUE_UZUN_DONEM = 'UzunDonem';
    /**
     * Constant for value 'Acente'
     * @return string 'Acente'
     */
    const VALUE_ACENTE = 'Acente';
    /**
     * Constant for value 'Ucak'
     * @return string 'Ucak'
     */
    const VALUE_UCAK = 'Ucak';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SURELI
     * @uses self::VALUE_MUNFERIT
     * @uses self::VALUE_OZMAL
     * @uses self::VALUE_UZUN_DONEM
     * @uses self::VALUE_ACENTE
     * @uses self::VALUE_UCAK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SURELI,
            self::VALUE_MUNFERIT,
            self::VALUE_OZMAL,
            self::VALUE_UZUN_DONEM,
            self::VALUE_ACENTE,
            self::VALUE_UCAK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
