<?php

namespace fk_\EnumType;

/**
 * This class stands for AracRenk EnumType
 * @subpackage Enumerations
 */
class AracRenk
{
    /**
     * Constant for value 'Beyaz'
     * @return string 'Beyaz'
     */
    const VALUE_BEYAZ = 'Beyaz';
    /**
     * Constant for value 'Gri'
     * @return string 'Gri'
     */
    const VALUE_GRI = 'Gri';
    /**
     * Constant for value 'Diger'
     * @return string 'Diger'
     */
    const VALUE_DIGER = 'Diger';
    /**
     * Constant for value 'Mavi_Beyaz'
     * @return string 'Mavi_Beyaz'
     */
    const VALUE_MAVI_BEYAZ = 'Mavi_Beyaz';
    /**
     * Constant for value 'Yesil_Beyaz'
     * @return string 'Yesil_Beyaz'
     */
    const VALUE_YESIL_BEYAZ = 'Yesil_Beyaz';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BEYAZ
     * @uses self::VALUE_GRI
     * @uses self::VALUE_DIGER
     * @uses self::VALUE_MAVI_BEYAZ
     * @uses self::VALUE_YESIL_BEYAZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BEYAZ,
            self::VALUE_GRI,
            self::VALUE_DIGER,
            self::VALUE_MAVI_BEYAZ,
            self::VALUE_YESIL_BEYAZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
