<?php

namespace fk_\EnumType;

/**
 * This class stands for SozlesmeTip EnumType
 * @subpackage Enumerations
 */
class SozlesmeTip
{
    /**
     * Constant for value 'Genel'
     * @return string 'Genel'
     */
    const VALUE_GENEL = 'Genel';
    /**
     * Constant for value 'Ozel'
     * @return string 'Ozel'
     */
    const VALUE_OZEL = 'Ozel';
    /**
     * Constant for value 'Sablon'
     * @return string 'Sablon'
     */
    const VALUE_SABLON = 'Sablon';
    /**
     * Constant for value 'Union'
     * @return string 'Union'
     */
    const VALUE_UNION = 'Union';
    /**
     * Constant for value 'Tumu'
     * @return string 'Tumu'
     */
    const VALUE_TUMU = 'Tumu';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GENEL
     * @uses self::VALUE_OZEL
     * @uses self::VALUE_SABLON
     * @uses self::VALUE_UNION
     * @uses self::VALUE_TUMU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GENEL,
            self::VALUE_OZEL,
            self::VALUE_SABLON,
            self::VALUE_UNION,
            self::VALUE_TUMU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
