<?php

namespace fk_\EnumType;

/**
 * This class stands for SozlesmeArtisOrani EnumType
 * @subpackage Enumerations
 */
class SozlesmeArtisOrani
{
    /**
     * Constant for value 'ArtisUygulansin'
     * @return string 'ArtisUygulansin'
     */
    const VALUE_ARTIS_UYGULANSIN = 'ArtisUygulansin';
    /**
     * Constant for value 'IndirimUygulansin'
     * @return string 'IndirimUygulansin'
     */
    const VALUE_INDIRIM_UYGULANSIN = 'IndirimUygulansin';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ARTIS_UYGULANSIN
     * @uses self::VALUE_INDIRIM_UYGULANSIN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ARTIS_UYGULANSIN,
            self::VALUE_INDIRIM_UYGULANSIN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
