<?php

namespace fk_\EnumType;

/**
 * This class stands for KargoDurum EnumType
 * @subpackage Enumerations
 */
class KargoDurum
{
    /**
     * Constant for value 'GondericiSubede'
     * @return string 'GondericiSubede'
     */
    const VALUE_GONDERICI_SUBEDE = 'GondericiSubede';
    /**
     * Constant for value 'Yolda'
     * @return string 'Yolda'
     */
    const VALUE_YOLDA = 'Yolda';
    /**
     * Constant for value 'AktarmaMerkezinde'
     * @return string 'AktarmaMerkezinde'
     */
    const VALUE_AKTARMA_MERKEZINDE = 'AktarmaMerkezinde';
    /**
     * Constant for value 'AliciSubede'
     * @return string 'AliciSubede'
     */
    const VALUE_ALICI_SUBEDE = 'AliciSubede';
    /**
     * Constant for value 'Dagitimda'
     * @return string 'Dagitimda'
     */
    const VALUE_DAGITIMDA = 'Dagitimda';
    /**
     * Constant for value 'TeslimEdildi'
     * @return string 'TeslimEdildi'
     */
    const VALUE_TESLIM_EDILDI = 'TeslimEdildi';
    /**
     * Constant for value 'Kayip'
     * @return string 'Kayip'
     */
    const VALUE_KAYIP = 'Kayip';
    /**
     * Constant for value 'Hasarli'
     * @return string 'Hasarli'
     */
    const VALUE_HASARLI = 'Hasarli';
    /**
     * Constant for value 'AraciFirmada'
     * @return string 'AraciFirmada'
     */
    const VALUE_ARACI_FIRMADA = 'AraciFirmada';
    /**
     * Constant for value 'BarkodDegisti'
     * @return string 'BarkodDegisti'
     */
    const VALUE_BARKOD_DEGISTI = 'BarkodDegisti';
    /**
     * Constant for value 'KargoSubede'
     * @return string 'KargoSubede'
     */
    const VALUE_KARGO_SUBEDE = 'KargoSubede';
    /**
     * Constant for value 'Gruplandi'
     * @return string 'Gruplandi'
     */
    const VALUE_GRUPLANDI = 'Gruplandi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GONDERICI_SUBEDE
     * @uses self::VALUE_YOLDA
     * @uses self::VALUE_AKTARMA_MERKEZINDE
     * @uses self::VALUE_ALICI_SUBEDE
     * @uses self::VALUE_DAGITIMDA
     * @uses self::VALUE_TESLIM_EDILDI
     * @uses self::VALUE_KAYIP
     * @uses self::VALUE_HASARLI
     * @uses self::VALUE_ARACI_FIRMADA
     * @uses self::VALUE_BARKOD_DEGISTI
     * @uses self::VALUE_KARGO_SUBEDE
     * @uses self::VALUE_GRUPLANDI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GONDERICI_SUBEDE,
            self::VALUE_YOLDA,
            self::VALUE_AKTARMA_MERKEZINDE,
            self::VALUE_ALICI_SUBEDE,
            self::VALUE_DAGITIMDA,
            self::VALUE_TESLIM_EDILDI,
            self::VALUE_KAYIP,
            self::VALUE_HASARLI,
            self::VALUE_ARACI_FIRMADA,
            self::VALUE_BARKOD_DEGISTI,
            self::VALUE_KARGO_SUBEDE,
            self::VALUE_GRUPLANDI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
