<?php

namespace fk_\EnumType;

/**
 * This class stands for KSeferDurum EnumType
 * @subpackage Enumerations
 */
class KSeferDurum
{
    /**
     * Constant for value 'Hazirlik'
     * @return string 'Hazirlik'
     */
    const VALUE_HAZIRLIK = 'Hazirlik';
    /**
     * Constant for value 'Basladi'
     * @return string 'Basladi'
     */
    const VALUE_BASLADI = 'Basladi';
    /**
     * Constant for value 'Bitti'
     * @return string 'Bitti'
     */
    const VALUE_BITTI = 'Bitti';
    /**
     * Constant for value 'Iptal'
     * @return string 'Iptal'
     */
    const VALUE_IPTAL = 'Iptal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HAZIRLIK
     * @uses self::VALUE_BASLADI
     * @uses self::VALUE_BITTI
     * @uses self::VALUE_IPTAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HAZIRLIK,
            self::VALUE_BASLADI,
            self::VALUE_BITTI,
            self::VALUE_IPTAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
