<?php

namespace fk_\EnumType;

/**
 * This class stands for KIptalDurumu EnumType
 * @subpackage Enumerations
 */
class KIptalDurumu
{
    /**
     * Constant for value 'Kullanimda'
     * @return string 'Kullanimda'
     */
    const VALUE_KULLANIMDA = 'Kullanimda';
    /**
     * Constant for value 'IptalIcinOnayda'
     * @return string 'IptalIcinOnayda'
     */
    const VALUE_IPTAL_ICIN_ONAYDA = 'IptalIcinOnayda';
    /**
     * Constant for value 'IptalOnaylandi'
     * @return string 'IptalOnaylandi'
     */
    const VALUE_IPTAL_ONAYLANDI = 'IptalOnaylandi';
    /**
     * Constant for value 'IptalEdildi'
     * @return string 'IptalEdildi'
     */
    const VALUE_IPTAL_EDILDI = 'IptalEdildi';
    /**
     * Constant for value 'Takipte'
     * @return string 'Takipte'
     */
    const VALUE_TAKIPTE = 'Takipte';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KULLANIMDA
     * @uses self::VALUE_IPTAL_ICIN_ONAYDA
     * @uses self::VALUE_IPTAL_ONAYLANDI
     * @uses self::VALUE_IPTAL_EDILDI
     * @uses self::VALUE_TAKIPTE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KULLANIMDA,
            self::VALUE_IPTAL_ICIN_ONAYDA,
            self::VALUE_IPTAL_ONAYLANDI,
            self::VALUE_IPTAL_EDILDI,
            self::VALUE_TAKIPTE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
