<?php

namespace fk_\EnumType;

/**
 * This class stands for ZimmetTuru EnumType
 * @subpackage Enumerations
 */
class ZimmetTuru
{
    /**
     * Constant for value 'Tesellum'
     * @return string 'Tesellum'
     */
    const VALUE_TESELLUM = 'Tesellum';
    /**
     * Constant for value 'Fatura'
     * @return string 'Fatura'
     */
    const VALUE_FATURA = 'Fatura';
    /**
     * Constant for value 'TTI'
     * @return string 'TTI'
     */
    const VALUE_TTI = 'TTI';
    /**
     * Constant for value 'SeferMuhurNo'
     * @return string 'SeferMuhurNo'
     */
    const VALUE_SEFER_MUHUR_NO = 'SeferMuhurNo';
    /**
     * Constant for value 'PosetSeriNo'
     * @return string 'PosetSeriNo'
     */
    const VALUE_POSET_SERI_NO = 'PosetSeriNo';
    /**
     * Constant for value 'MalKabulSipNo'
     * @return string 'MalKabulSipNo'
     */
    const VALUE_MAL_KABUL_SIP_NO = 'MalKabulSipNo';
    /**
     * Constant for value 'HizliTesellum'
     * @return string 'HizliTesellum'
     */
    const VALUE_HIZLI_TESELLUM = 'HizliTesellum';
    /**
     * Constant for value 'HizliTesellumIslemNo'
     * @return string 'HizliTesellumIslemNo'
     */
    const VALUE_HIZLI_TESELLUM_ISLEM_NO = 'HizliTesellumIslemNo';
    /**
     * Constant for value 'EFatura'
     * @return string 'EFatura'
     */
    const VALUE_EFATURA = 'EFatura';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TESELLUM
     * @uses self::VALUE_FATURA
     * @uses self::VALUE_TTI
     * @uses self::VALUE_SEFER_MUHUR_NO
     * @uses self::VALUE_POSET_SERI_NO
     * @uses self::VALUE_MAL_KABUL_SIP_NO
     * @uses self::VALUE_HIZLI_TESELLUM
     * @uses self::VALUE_HIZLI_TESELLUM_ISLEM_NO
     * @uses self::VALUE_EFATURA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TESELLUM,
            self::VALUE_FATURA,
            self::VALUE_TTI,
            self::VALUE_SEFER_MUHUR_NO,
            self::VALUE_POSET_SERI_NO,
            self::VALUE_MAL_KABUL_SIP_NO,
            self::VALUE_HIZLI_TESELLUM,
            self::VALUE_HIZLI_TESELLUM_ISLEM_NO,
            self::VALUE_EFATURA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
