<?php

namespace fk_\EnumType;

/**
 * This class stands for FaaliyetNoktasi EnumType
 * @subpackage Enumerations
 */
class FaaliyetNoktasi
{
    /**
     * Constant for value 'UretimFaaliyeti'
     * @return string 'UretimFaaliyeti'
     */
    const VALUE_URETIM_FAALIYETI = 'UretimFaaliyeti';
    /**
     * Constant for value 'DigerFaaliyet'
     * @return string 'DigerFaaliyet'
     */
    const VALUE_DIGER_FAALIYET = 'DigerFaaliyet';
    /**
     * Constant for value 'Personel'
     * @return string 'Personel'
     */
    const VALUE_PERSONEL = 'Personel';
    /**
     * Constant for value 'Proje'
     * @return string 'Proje'
     */
    const VALUE_PROJE = 'Proje';
    /**
     * Constant for value 'Siparis'
     * @return string 'Siparis'
     */
    const VALUE_SIPARIS = 'Siparis';
    /**
     * Constant for value 'Urun'
     * @return string 'Urun'
     */
    const VALUE_URUN = 'Urun';
    /**
     * Constant for value 'Yarimamul'
     * @return string 'Yarimamul'
     */
    const VALUE_YARIMAMUL = 'Yarimamul';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_URETIM_FAALIYETI
     * @uses self::VALUE_DIGER_FAALIYET
     * @uses self::VALUE_PERSONEL
     * @uses self::VALUE_PROJE
     * @uses self::VALUE_SIPARIS
     * @uses self::VALUE_URUN
     * @uses self::VALUE_YARIMAMUL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_URETIM_FAALIYETI,
            self::VALUE_DIGER_FAALIYET,
            self::VALUE_PERSONEL,
            self::VALUE_PROJE,
            self::VALUE_SIPARIS,
            self::VALUE_URUN,
            self::VALUE_YARIMAMUL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
