<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSozlesme StructType
 * @subpackage Structs
 */
class KSozlesme extends Entity
{
    /**
     * The TeklifTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TeklifTar;
    /**
     * The TeklifGecerliTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TeklifGecerliTar;
    /**
     * The SozlesmeTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SozlesmeTar;
    /**
     * The SozlesmeGecerliTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SozlesmeGecerliTar;
    /**
     * The Durum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Durum;
    /**
     * The Tipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tipi;
    /**
     * The CiroTahmin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CiroTahmin;
    /**
     * The Tutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tutar;
    /**
     * The DesiTahmin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DesiTahmin;
    /**
     * The OdemeSuresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OdemeSuresi;
    /**
     * The IndirimOran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IndirimOran;
    /**
     * The ArtisOran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ArtisOran;
    /**
     * The SP_OdemePlani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_OdemePlani;
    /**
     * The BelgeTip
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BelgeTip;
    /**
     * The KDVOran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KDVOran;
    /**
     * The YFLUAEvrakLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $YFLUAEvrakLimiti;
    /**
     * The YFLUAAliciCariLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $YFLUAAliciCariLimiti;
    /**
     * The YFLUAGonderenCariLimiti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $YFLUAGonderenCariLimiti;
    /**
     * The IsUADaKullan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsUADaKullan;
    /**
     * The IsUAvrakKabulEdiliyor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsUAvrakKabulEdiliyor;
    /**
     * The TesellumFaturalamaDonemi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TesellumFaturalamaDonemi;
    /**
     * The Limit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Limit;
    /**
     * The OdemePlani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemePlani;
    /**
     * The HaftaGun
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $HaftaGun;
    /**
     * The Aygun
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Aygun;
    /**
     * The OdemeTipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemeTipi;
    /**
     * The CekVadesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CekVadesi;
    /**
     * The CariBakiye
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CariBakiye;
    /**
     * The LimitAsimTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LimitAsimTarihi;
    /**
     * The MinimumOdemeTutarYuzdesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MinimumOdemeTutarYuzdesi;
    /**
     * The MinumumOdemeTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinumumOdemeTutari;
    /**
     * The RiskLimitiIzinVerenBirim
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $RiskLimitiIzinVerenBirim;
    /**
     * The OdemePlaniIzinVerenBirim
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemePlaniIzinVerenBirim;
    /**
     * The EkOdemeGunu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EkOdemeGunu;
    /**
     * The EkLimitGunu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EkLimitGunu;
    /**
     * The IlkOdemeTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IlkOdemeTarihi;
    /**
     * The SonOdemeTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SonOdemeTarihi;
    /**
     * The ErtelenenLimitTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErtelenenLimitTarihi;
    /**
     * The ErtelenenOdemeTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ErtelenenOdemeTarihi;
    /**
     * The IsOnOnay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsOnOnay;
    /**
     * The SozlesmeGecerliBasTar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SozlesmeGecerliBasTar;
    /**
     * The TahsilatUcreti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TahsilatUcreti;
    /**
     * The KolibasiIndirimBasAdet
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KolibasiIndirimBasAdet;
    /**
     * The KolibasiIndirimOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KolibasiIndirimOrani;
    /**
     * The KOLimit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KOLimit;
    /**
     * The KOBarajTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KOBarajTutari;
    /**
     * The KOBarajUstuOran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KOBarajUstuOran;
    /**
     * The FiyatHesaplamaKriteri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FiyatHesaplamaKriteri;
    /**
     * The KOPosCozumGunSayisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $KOPosCozumGunSayisi;
    /**
     * The SozlesmeArtisOraniDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SozlesmeArtisOraniDurumu;
    /**
     * The TesellumTutariGorunmesin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TesellumTutariGorunmesin;
    /**
     * The ErkenOdemeYuzdesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ErkenOdemeYuzdesi;
    /**
     * The KOAHEkHizmetDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KOAHEkHizmetDurumu;
    /**
     * The IsGittiGidiyorCarisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsGittiGidiyorCarisi;
    /**
     * The GittiGidiyorVirmanTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GittiGidiyorVirmanTutari;
    /**
     * The SozlesmeKaynagi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $SozlesmeKaynagi;
    /**
     * The OdemeGunu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OdemeGunu;
    /**
     * The IsTurkiyeGeneliGecerliOlsun
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTurkiyeGeneliGecerliOlsun;
    /**
     * The IsEphHesaplansin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsEphHesaplansin;
    /**
     * The UcretsizSmsKullansin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UcretsizSmsKullansin;
    /**
     * The Onaymi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Onaymi;
    /**
     * The HizmetKDVsiKullan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $HizmetKDVsiKullan;
    /**
     * The TahsilatVadesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TahsilatVadesi;
    /**
     * The Hizmeti
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KHizmetPointer
     */
    public $Hizmeti;
    /**
     * The Carisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $Carisi;
    /**
     * The Revizyonu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSozlesmePointer
     */
    public $Revizyonu;
    /**
     * The Sube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $Sube;
    /**
     * The SozlesmeRef
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSozlesmePointer
     */
    public $SozlesmeRef;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The RedNeden
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RedNeden;
    /**
     * The Proje
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KProjePointer
     */
    public $Proje;
    /**
     * The TahsilatSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $TahsilatSube;
    /**
     * The TesellumFaturalayacakSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $TesellumFaturalayacakSube;
    /**
     * The OdemeCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $OdemeCari;
    /**
     * The IslemDoviz
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizTuruPointer
     */
    public $IslemDoviz;
    /**
     * The SozlesmeBolgeleri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\ArrayType\ArrayOfKSozlesmeBolge
     */
    public $SozlesmeBolgeleri;
    /**
     * The CekirdekCarisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\CariFisiPointer
     */
    public $CekirdekCarisi;
    /**
     * The Firma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KYurtDisiFirmaTanimlamaPointer
     */
    public $Firma;
    /**
     * The SozlesmeMailleri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariMailPointer
     */
    public $SozlesmeMailleri;
    /**
     * The SozlesmeyeDahilOlanGitGelEkHizmetleri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\ArrayType\ArrayOfKEkHizmet
     */
    public $SozlesmeyeDahilOlanGitGelEkHizmetleri;
    /**
     * Constructor method for KSozlesme
     * @uses KSozlesme::setTeklifTar()
     * @uses KSozlesme::setTeklifGecerliTar()
     * @uses KSozlesme::setSozlesmeTar()
     * @uses KSozlesme::setSozlesmeGecerliTar()
     * @uses KSozlesme::setDurum()
     * @uses KSozlesme::setTipi()
     * @uses KSozlesme::setCiroTahmin()
     * @uses KSozlesme::setTutar()
     * @uses KSozlesme::setDesiTahmin()
     * @uses KSozlesme::setOdemeSuresi()
     * @uses KSozlesme::setIndirimOran()
     * @uses KSozlesme::setArtisOran()
     * @uses KSozlesme::setSP_OdemePlani()
     * @uses KSozlesme::setBelgeTip()
     * @uses KSozlesme::setKDVOran()
     * @uses KSozlesme::setYFLUAEvrakLimiti()
     * @uses KSozlesme::setYFLUAAliciCariLimiti()
     * @uses KSozlesme::setYFLUAGonderenCariLimiti()
     * @uses KSozlesme::setIsUADaKullan()
     * @uses KSozlesme::setIsUAvrakKabulEdiliyor()
     * @uses KSozlesme::setTesellumFaturalamaDonemi()
     * @uses KSozlesme::setLimit()
     * @uses KSozlesme::setOdemePlani()
     * @uses KSozlesme::setHaftaGun()
     * @uses KSozlesme::setAygun()
     * @uses KSozlesme::setOdemeTipi()
     * @uses KSozlesme::setCekVadesi()
     * @uses KSozlesme::setCariBakiye()
     * @uses KSozlesme::setLimitAsimTarihi()
     * @uses KSozlesme::setMinimumOdemeTutarYuzdesi()
     * @uses KSozlesme::setMinumumOdemeTutari()
     * @uses KSozlesme::setRiskLimitiIzinVerenBirim()
     * @uses KSozlesme::setOdemePlaniIzinVerenBirim()
     * @uses KSozlesme::setEkOdemeGunu()
     * @uses KSozlesme::setEkLimitGunu()
     * @uses KSozlesme::setIlkOdemeTarihi()
     * @uses KSozlesme::setSonOdemeTarihi()
     * @uses KSozlesme::setErtelenenLimitTarihi()
     * @uses KSozlesme::setErtelenenOdemeTarihi()
     * @uses KSozlesme::setIsOnOnay()
     * @uses KSozlesme::setSozlesmeGecerliBasTar()
     * @uses KSozlesme::setTahsilatUcreti()
     * @uses KSozlesme::setKolibasiIndirimBasAdet()
     * @uses KSozlesme::setKolibasiIndirimOrani()
     * @uses KSozlesme::setKOLimit()
     * @uses KSozlesme::setKOBarajTutari()
     * @uses KSozlesme::setKOBarajUstuOran()
     * @uses KSozlesme::setFiyatHesaplamaKriteri()
     * @uses KSozlesme::setKOPosCozumGunSayisi()
     * @uses KSozlesme::setSozlesmeArtisOraniDurumu()
     * @uses KSozlesme::setTesellumTutariGorunmesin()
     * @uses KSozlesme::setErkenOdemeYuzdesi()
     * @uses KSozlesme::setKOAHEkHizmetDurumu()
     * @uses KSozlesme::setIsGittiGidiyorCarisi()
     * @uses KSozlesme::setGittiGidiyorVirmanTutari()
     * @uses KSozlesme::setSozlesmeKaynagi()
     * @uses KSozlesme::setOdemeGunu()
     * @uses KSozlesme::setIsTurkiyeGeneliGecerliOlsun()
     * @uses KSozlesme::setIsEphHesaplansin()
     * @uses KSozlesme::setUcretsizSmsKullansin()
     * @uses KSozlesme::setOnaymi()
     * @uses KSozlesme::setHizmetKDVsiKullan()
     * @uses KSozlesme::setTahsilatVadesi()
     * @uses KSozlesme::setHizmeti()
     * @uses KSozlesme::setCarisi()
     * @uses KSozlesme::setRevizyonu()
     * @uses KSozlesme::setSube()
     * @uses KSozlesme::setSozlesmeRef()
     * @uses KSozlesme::setAdi()
     * @uses KSozlesme::setRedNeden()
     * @uses KSozlesme::setProje()
     * @uses KSozlesme::setTahsilatSube()
     * @uses KSozlesme::setTesellumFaturalayacakSube()
     * @uses KSozlesme::setOdemeCari()
     * @uses KSozlesme::setIslemDoviz()
     * @uses KSozlesme::setSozlesmeBolgeleri()
     * @uses KSozlesme::setCekirdekCarisi()
     * @uses KSozlesme::setFirma()
     * @uses KSozlesme::setSozlesmeMailleri()
     * @uses KSozlesme::setSozlesmeyeDahilOlanGitGelEkHizmetleri()
     * @param string $teklifTar
     * @param string $teklifGecerliTar
     * @param string $sozlesmeTar
     * @param string $sozlesmeGecerliTar
     * @param string $durum
     * @param string $tipi
     * @param float $ciroTahmin
     * @param float $tutar
     * @param float $desiTahmin
     * @param float $odemeSuresi
     * @param float $indirimOran
     * @param float $artisOran
     * @param int $sP_OdemePlani
     * @param string $belgeTip
     * @param float $kDVOran
     * @param float $yFLUAEvrakLimiti
     * @param float $yFLUAAliciCariLimiti
     * @param float $yFLUAGonderenCariLimiti
     * @param bool $isUADaKullan
     * @param bool $isUAvrakKabulEdiliyor
     * @param string $tesellumFaturalamaDonemi
     * @param float $limit
     * @param string $odemePlani
     * @param string $haftaGun
     * @param int $aygun
     * @param string $odemeTipi
     * @param int $cekVadesi
     * @param float $cariBakiye
     * @param string $limitAsimTarihi
     * @param int $minimumOdemeTutarYuzdesi
     * @param float $minumumOdemeTutari
     * @param string $riskLimitiIzinVerenBirim
     * @param string $odemePlaniIzinVerenBirim
     * @param int $ekOdemeGunu
     * @param int $ekLimitGunu
     * @param string $ilkOdemeTarihi
     * @param string $sonOdemeTarihi
     * @param string $ertelenenLimitTarihi
     * @param string $ertelenenOdemeTarihi
     * @param bool $isOnOnay
     * @param string $sozlesmeGecerliBasTar
     * @param float $tahsilatUcreti
     * @param int $kolibasiIndirimBasAdet
     * @param float $kolibasiIndirimOrani
     * @param float $kOLimit
     * @param float $kOBarajTutari
     * @param float $kOBarajUstuOran
     * @param string $fiyatHesaplamaKriteri
     * @param int $kOPosCozumGunSayisi
     * @param string $sozlesmeArtisOraniDurumu
     * @param bool $tesellumTutariGorunmesin
     * @param float $erkenOdemeYuzdesi
     * @param string $kOAHEkHizmetDurumu
     * @param bool $isGittiGidiyorCarisi
     * @param float $gittiGidiyorVirmanTutari
     * @param string $sozlesmeKaynagi
     * @param int $odemeGunu
     * @param bool $isTurkiyeGeneliGecerliOlsun
     * @param bool $isEphHesaplansin
     * @param bool $ucretsizSmsKullansin
     * @param bool $onaymi
     * @param bool $hizmetKDVsiKullan
     * @param int $tahsilatVadesi
     * @param \fk_\StructType\KHizmetPointer $hizmeti
     * @param \fk_\StructType\KCariPointer $carisi
     * @param \fk_\StructType\KSozlesmePointer $revizyonu
     * @param \fk_\StructType\KSubePointer $sube
     * @param \fk_\StructType\KSozlesmePointer $sozlesmeRef
     * @param string $adi
     * @param string $redNeden
     * @param \fk_\StructType\KProjePointer $proje
     * @param \fk_\StructType\KSubePointer $tahsilatSube
     * @param \fk_\StructType\KSubePointer $tesellumFaturalayacakSube
     * @param \fk_\StructType\KCariPointer $odemeCari
     * @param \fk_\StructType\DovizTuruPointer $islemDoviz
     * @param \fk_\ArrayType\ArrayOfKSozlesmeBolge $sozlesmeBolgeleri
     * @param \fk_\StructType\CariFisiPointer $cekirdekCarisi
     * @param \fk_\StructType\KYurtDisiFirmaTanimlamaPointer $firma
     * @param \fk_\StructType\KCariMailPointer $sozlesmeMailleri
     * @param \fk_\ArrayType\ArrayOfKEkHizmet $sozlesmeyeDahilOlanGitGelEkHizmetleri
     */
    public function __construct($teklifTar = null, $teklifGecerliTar = null, $sozlesmeTar = null, $sozlesmeGecerliTar = null, $durum = null, $tipi = null, $ciroTahmin = null, $tutar = null, $desiTahmin = null, $odemeSuresi = null, $indirimOran = null, $artisOran = null, $sP_OdemePlani = null, $belgeTip = null, $kDVOran = null, $yFLUAEvrakLimiti = null, $yFLUAAliciCariLimiti = null, $yFLUAGonderenCariLimiti = null, $isUADaKullan = null, $isUAvrakKabulEdiliyor = null, $tesellumFaturalamaDonemi = null, $limit = null, $odemePlani = null, $haftaGun = null, $aygun = null, $odemeTipi = null, $cekVadesi = null, $cariBakiye = null, $limitAsimTarihi = null, $minimumOdemeTutarYuzdesi = null, $minumumOdemeTutari = null, $riskLimitiIzinVerenBirim = null, $odemePlaniIzinVerenBirim = null, $ekOdemeGunu = null, $ekLimitGunu = null, $ilkOdemeTarihi = null, $sonOdemeTarihi = null, $ertelenenLimitTarihi = null, $ertelenenOdemeTarihi = null, $isOnOnay = null, $sozlesmeGecerliBasTar = null, $tahsilatUcreti = null, $kolibasiIndirimBasAdet = null, $kolibasiIndirimOrani = null, $kOLimit = null, $kOBarajTutari = null, $kOBarajUstuOran = null, $fiyatHesaplamaKriteri = null, $kOPosCozumGunSayisi = null, $sozlesmeArtisOraniDurumu = null, $tesellumTutariGorunmesin = null, $erkenOdemeYuzdesi = null, $kOAHEkHizmetDurumu = null, $isGittiGidiyorCarisi = null, $gittiGidiyorVirmanTutari = null, $sozlesmeKaynagi = null, $odemeGunu = null, $isTurkiyeGeneliGecerliOlsun = null, $isEphHesaplansin = null, $ucretsizSmsKullansin = null, $onaymi = null, $hizmetKDVsiKullan = null, $tahsilatVadesi = null, \fk_\StructType\KHizmetPointer $hizmeti = null, \fk_\StructType\KCariPointer $carisi = null, \fk_\StructType\KSozlesmePointer $revizyonu = null, \fk_\StructType\KSubePointer $sube = null, \fk_\StructType\KSozlesmePointer $sozlesmeRef = null, $adi = null, $redNeden = null, \fk_\StructType\KProjePointer $proje = null, \fk_\StructType\KSubePointer $tahsilatSube = null, \fk_\StructType\KSubePointer $tesellumFaturalayacakSube = null, \fk_\StructType\KCariPointer $odemeCari = null, \fk_\StructType\DovizTuruPointer $islemDoviz = null, \fk_\ArrayType\ArrayOfKSozlesmeBolge $sozlesmeBolgeleri = null, \fk_\StructType\CariFisiPointer $cekirdekCarisi = null, \fk_\StructType\KYurtDisiFirmaTanimlamaPointer $firma = null, \fk_\StructType\KCariMailPointer $sozlesmeMailleri = null, \fk_\ArrayType\ArrayOfKEkHizmet $sozlesmeyeDahilOlanGitGelEkHizmetleri = null)
    {
        $this
            ->setTeklifTar($teklifTar)
            ->setTeklifGecerliTar($teklifGecerliTar)
            ->setSozlesmeTar($sozlesmeTar)
            ->setSozlesmeGecerliTar($sozlesmeGecerliTar)
            ->setDurum($durum)
            ->setTipi($tipi)
            ->setCiroTahmin($ciroTahmin)
            ->setTutar($tutar)
            ->setDesiTahmin($desiTahmin)
            ->setOdemeSuresi($odemeSuresi)
            ->setIndirimOran($indirimOran)
            ->setArtisOran($artisOran)
            ->setSP_OdemePlani($sP_OdemePlani)
            ->setBelgeTip($belgeTip)
            ->setKDVOran($kDVOran)
            ->setYFLUAEvrakLimiti($yFLUAEvrakLimiti)
            ->setYFLUAAliciCariLimiti($yFLUAAliciCariLimiti)
            ->setYFLUAGonderenCariLimiti($yFLUAGonderenCariLimiti)
            ->setIsUADaKullan($isUADaKullan)
            ->setIsUAvrakKabulEdiliyor($isUAvrakKabulEdiliyor)
            ->setTesellumFaturalamaDonemi($tesellumFaturalamaDonemi)
            ->setLimit($limit)
            ->setOdemePlani($odemePlani)
            ->setHaftaGun($haftaGun)
            ->setAygun($aygun)
            ->setOdemeTipi($odemeTipi)
            ->setCekVadesi($cekVadesi)
            ->setCariBakiye($cariBakiye)
            ->setLimitAsimTarihi($limitAsimTarihi)
            ->setMinimumOdemeTutarYuzdesi($minimumOdemeTutarYuzdesi)
            ->setMinumumOdemeTutari($minumumOdemeTutari)
            ->setRiskLimitiIzinVerenBirim($riskLimitiIzinVerenBirim)
            ->setOdemePlaniIzinVerenBirim($odemePlaniIzinVerenBirim)
            ->setEkOdemeGunu($ekOdemeGunu)
            ->setEkLimitGunu($ekLimitGunu)
            ->setIlkOdemeTarihi($ilkOdemeTarihi)
            ->setSonOdemeTarihi($sonOdemeTarihi)
            ->setErtelenenLimitTarihi($ertelenenLimitTarihi)
            ->setErtelenenOdemeTarihi($ertelenenOdemeTarihi)
            ->setIsOnOnay($isOnOnay)
            ->setSozlesmeGecerliBasTar($sozlesmeGecerliBasTar)
            ->setTahsilatUcreti($tahsilatUcreti)
            ->setKolibasiIndirimBasAdet($kolibasiIndirimBasAdet)
            ->setKolibasiIndirimOrani($kolibasiIndirimOrani)
            ->setKOLimit($kOLimit)
            ->setKOBarajTutari($kOBarajTutari)
            ->setKOBarajUstuOran($kOBarajUstuOran)
            ->setFiyatHesaplamaKriteri($fiyatHesaplamaKriteri)
            ->setKOPosCozumGunSayisi($kOPosCozumGunSayisi)
            ->setSozlesmeArtisOraniDurumu($sozlesmeArtisOraniDurumu)
            ->setTesellumTutariGorunmesin($tesellumTutariGorunmesin)
            ->setErkenOdemeYuzdesi($erkenOdemeYuzdesi)
            ->setKOAHEkHizmetDurumu($kOAHEkHizmetDurumu)
            ->setIsGittiGidiyorCarisi($isGittiGidiyorCarisi)
            ->setGittiGidiyorVirmanTutari($gittiGidiyorVirmanTutari)
            ->setSozlesmeKaynagi($sozlesmeKaynagi)
            ->setOdemeGunu($odemeGunu)
            ->setIsTurkiyeGeneliGecerliOlsun($isTurkiyeGeneliGecerliOlsun)
            ->setIsEphHesaplansin($isEphHesaplansin)
            ->setUcretsizSmsKullansin($ucretsizSmsKullansin)
            ->setOnaymi($onaymi)
            ->setHizmetKDVsiKullan($hizmetKDVsiKullan)
            ->setTahsilatVadesi($tahsilatVadesi)
            ->setHizmeti($hizmeti)
            ->setCarisi($carisi)
            ->setRevizyonu($revizyonu)
            ->setSube($sube)
            ->setSozlesmeRef($sozlesmeRef)
            ->setAdi($adi)
            ->setRedNeden($redNeden)
            ->setProje($proje)
            ->setTahsilatSube($tahsilatSube)
            ->setTesellumFaturalayacakSube($tesellumFaturalayacakSube)
            ->setOdemeCari($odemeCari)
            ->setIslemDoviz($islemDoviz)
            ->setSozlesmeBolgeleri($sozlesmeBolgeleri)
            ->setCekirdekCarisi($cekirdekCarisi)
            ->setFirma($firma)
            ->setSozlesmeMailleri($sozlesmeMailleri)
            ->setSozlesmeyeDahilOlanGitGelEkHizmetleri($sozlesmeyeDahilOlanGitGelEkHizmetleri);
    }
    /**
     * Get TeklifTar value
     * @return string
     */
    public function getTeklifTar()
    {
        return $this->TeklifTar;
    }
    /**
     * Set TeklifTar value
     * @param string $teklifTar
     * @return \fk_\StructType\KSozlesme
     */
    public function setTeklifTar($teklifTar = null)
    {
        // validation for constraint: string
        if (!is_null($teklifTar) && !is_string($teklifTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teklifTar, true), gettype($teklifTar)), __LINE__);
        }
        $this->TeklifTar = $teklifTar;
        return $this;
    }
    /**
     * Get TeklifGecerliTar value
     * @return string
     */
    public function getTeklifGecerliTar()
    {
        return $this->TeklifGecerliTar;
    }
    /**
     * Set TeklifGecerliTar value
     * @param string $teklifGecerliTar
     * @return \fk_\StructType\KSozlesme
     */
    public function setTeklifGecerliTar($teklifGecerliTar = null)
    {
        // validation for constraint: string
        if (!is_null($teklifGecerliTar) && !is_string($teklifGecerliTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($teklifGecerliTar, true), gettype($teklifGecerliTar)), __LINE__);
        }
        $this->TeklifGecerliTar = $teklifGecerliTar;
        return $this;
    }
    /**
     * Get SozlesmeTar value
     * @return string
     */
    public function getSozlesmeTar()
    {
        return $this->SozlesmeTar;
    }
    /**
     * Set SozlesmeTar value
     * @param string $sozlesmeTar
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeTar($sozlesmeTar = null)
    {
        // validation for constraint: string
        if (!is_null($sozlesmeTar) && !is_string($sozlesmeTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sozlesmeTar, true), gettype($sozlesmeTar)), __LINE__);
        }
        $this->SozlesmeTar = $sozlesmeTar;
        return $this;
    }
    /**
     * Get SozlesmeGecerliTar value
     * @return string
     */
    public function getSozlesmeGecerliTar()
    {
        return $this->SozlesmeGecerliTar;
    }
    /**
     * Set SozlesmeGecerliTar value
     * @param string $sozlesmeGecerliTar
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeGecerliTar($sozlesmeGecerliTar = null)
    {
        // validation for constraint: string
        if (!is_null($sozlesmeGecerliTar) && !is_string($sozlesmeGecerliTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sozlesmeGecerliTar, true), gettype($sozlesmeGecerliTar)), __LINE__);
        }
        $this->SozlesmeGecerliTar = $sozlesmeGecerliTar;
        return $this;
    }
    /**
     * Get Durum value
     * @return string
     */
    public function getDurum()
    {
        return $this->Durum;
    }
    /**
     * Set Durum value
     * @uses \fk_\EnumType\KSozlesmeDurum::valueIsValid()
     * @uses \fk_\EnumType\KSozlesmeDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durum
     * @return \fk_\StructType\KSozlesme
     */
    public function setDurum($durum = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KSozlesmeDurum::valueIsValid($durum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KSozlesmeDurum', is_array($durum) ? implode(', ', $durum) : var_export($durum, true), implode(', ', \fk_\EnumType\KSozlesmeDurum::getValidValues())), __LINE__);
        }
        $this->Durum = $durum;
        return $this;
    }
    /**
     * Get Tipi value
     * @return string
     */
    public function getTipi()
    {
        return $this->Tipi;
    }
    /**
     * Set Tipi value
     * @uses \fk_\EnumType\SozlesmeTip::valueIsValid()
     * @uses \fk_\EnumType\SozlesmeTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipi
     * @return \fk_\StructType\KSozlesme
     */
    public function setTipi($tipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\SozlesmeTip::valueIsValid($tipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\SozlesmeTip', is_array($tipi) ? implode(', ', $tipi) : var_export($tipi, true), implode(', ', \fk_\EnumType\SozlesmeTip::getValidValues())), __LINE__);
        }
        $this->Tipi = $tipi;
        return $this;
    }
    /**
     * Get CiroTahmin value
     * @return float
     */
    public function getCiroTahmin()
    {
        return $this->CiroTahmin;
    }
    /**
     * Set CiroTahmin value
     * @param float $ciroTahmin
     * @return \fk_\StructType\KSozlesme
     */
    public function setCiroTahmin($ciroTahmin = null)
    {
        // validation for constraint: float
        if (!is_null($ciroTahmin) && !(is_float($ciroTahmin) || is_numeric($ciroTahmin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ciroTahmin, true), gettype($ciroTahmin)), __LINE__);
        }
        $this->CiroTahmin = $ciroTahmin;
        return $this;
    }
    /**
     * Get Tutar value
     * @return float
     */
    public function getTutar()
    {
        return $this->Tutar;
    }
    /**
     * Set Tutar value
     * @param float $tutar
     * @return \fk_\StructType\KSozlesme
     */
    public function setTutar($tutar = null)
    {
        // validation for constraint: float
        if (!is_null($tutar) && !(is_float($tutar) || is_numeric($tutar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tutar, true), gettype($tutar)), __LINE__);
        }
        $this->Tutar = $tutar;
        return $this;
    }
    /**
     * Get DesiTahmin value
     * @return float
     */
    public function getDesiTahmin()
    {
        return $this->DesiTahmin;
    }
    /**
     * Set DesiTahmin value
     * @param float $desiTahmin
     * @return \fk_\StructType\KSozlesme
     */
    public function setDesiTahmin($desiTahmin = null)
    {
        // validation for constraint: float
        if (!is_null($desiTahmin) && !(is_float($desiTahmin) || is_numeric($desiTahmin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desiTahmin, true), gettype($desiTahmin)), __LINE__);
        }
        $this->DesiTahmin = $desiTahmin;
        return $this;
    }
    /**
     * Get OdemeSuresi value
     * @return float
     */
    public function getOdemeSuresi()
    {
        return $this->OdemeSuresi;
    }
    /**
     * Set OdemeSuresi value
     * @param float $odemeSuresi
     * @return \fk_\StructType\KSozlesme
     */
    public function setOdemeSuresi($odemeSuresi = null)
    {
        // validation for constraint: float
        if (!is_null($odemeSuresi) && !(is_float($odemeSuresi) || is_numeric($odemeSuresi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($odemeSuresi, true), gettype($odemeSuresi)), __LINE__);
        }
        $this->OdemeSuresi = $odemeSuresi;
        return $this;
    }
    /**
     * Get IndirimOran value
     * @return float
     */
    public function getIndirimOran()
    {
        return $this->IndirimOran;
    }
    /**
     * Set IndirimOran value
     * @param float $indirimOran
     * @return \fk_\StructType\KSozlesme
     */
    public function setIndirimOran($indirimOran = null)
    {
        // validation for constraint: float
        if (!is_null($indirimOran) && !(is_float($indirimOran) || is_numeric($indirimOran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($indirimOran, true), gettype($indirimOran)), __LINE__);
        }
        $this->IndirimOran = $indirimOran;
        return $this;
    }
    /**
     * Get ArtisOran value
     * @return float
     */
    public function getArtisOran()
    {
        return $this->ArtisOran;
    }
    /**
     * Set ArtisOran value
     * @param float $artisOran
     * @return \fk_\StructType\KSozlesme
     */
    public function setArtisOran($artisOran = null)
    {
        // validation for constraint: float
        if (!is_null($artisOran) && !(is_float($artisOran) || is_numeric($artisOran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($artisOran, true), gettype($artisOran)), __LINE__);
        }
        $this->ArtisOran = $artisOran;
        return $this;
    }
    /**
     * Get SP_OdemePlani value
     * @return int
     */
    public function getSP_OdemePlani()
    {
        return $this->SP_OdemePlani;
    }
    /**
     * Set SP_OdemePlani value
     * @param int $sP_OdemePlani
     * @return \fk_\StructType\KSozlesme
     */
    public function setSP_OdemePlani($sP_OdemePlani = null)
    {
        // validation for constraint: int
        if (!is_null($sP_OdemePlani) && !(is_int($sP_OdemePlani) || ctype_digit($sP_OdemePlani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_OdemePlani, true), gettype($sP_OdemePlani)), __LINE__);
        }
        $this->SP_OdemePlani = $sP_OdemePlani;
        return $this;
    }
    /**
     * Get BelgeTip value
     * @return string
     */
    public function getBelgeTip()
    {
        return $this->BelgeTip;
    }
    /**
     * Set BelgeTip value
     * @uses \fk_\EnumType\SozlesmeKullanilacakBelge::valueIsValid()
     * @uses \fk_\EnumType\SozlesmeKullanilacakBelge::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $belgeTip
     * @return \fk_\StructType\KSozlesme
     */
    public function setBelgeTip($belgeTip = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\SozlesmeKullanilacakBelge::valueIsValid($belgeTip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\SozlesmeKullanilacakBelge', is_array($belgeTip) ? implode(', ', $belgeTip) : var_export($belgeTip, true), implode(', ', \fk_\EnumType\SozlesmeKullanilacakBelge::getValidValues())), __LINE__);
        }
        $this->BelgeTip = $belgeTip;
        return $this;
    }
    /**
     * Get KDVOran value
     * @return float
     */
    public function getKDVOran()
    {
        return $this->KDVOran;
    }
    /**
     * Set KDVOran value
     * @param float $kDVOran
     * @return \fk_\StructType\KSozlesme
     */
    public function setKDVOran($kDVOran = null)
    {
        // validation for constraint: float
        if (!is_null($kDVOran) && !(is_float($kDVOran) || is_numeric($kDVOran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kDVOran, true), gettype($kDVOran)), __LINE__);
        }
        $this->KDVOran = $kDVOran;
        return $this;
    }
    /**
     * Get YFLUAEvrakLimiti value
     * @return float
     */
    public function getYFLUAEvrakLimiti()
    {
        return $this->YFLUAEvrakLimiti;
    }
    /**
     * Set YFLUAEvrakLimiti value
     * @param float $yFLUAEvrakLimiti
     * @return \fk_\StructType\KSozlesme
     */
    public function setYFLUAEvrakLimiti($yFLUAEvrakLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($yFLUAEvrakLimiti) && !(is_float($yFLUAEvrakLimiti) || is_numeric($yFLUAEvrakLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yFLUAEvrakLimiti, true), gettype($yFLUAEvrakLimiti)), __LINE__);
        }
        $this->YFLUAEvrakLimiti = $yFLUAEvrakLimiti;
        return $this;
    }
    /**
     * Get YFLUAAliciCariLimiti value
     * @return float
     */
    public function getYFLUAAliciCariLimiti()
    {
        return $this->YFLUAAliciCariLimiti;
    }
    /**
     * Set YFLUAAliciCariLimiti value
     * @param float $yFLUAAliciCariLimiti
     * @return \fk_\StructType\KSozlesme
     */
    public function setYFLUAAliciCariLimiti($yFLUAAliciCariLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($yFLUAAliciCariLimiti) && !(is_float($yFLUAAliciCariLimiti) || is_numeric($yFLUAAliciCariLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yFLUAAliciCariLimiti, true), gettype($yFLUAAliciCariLimiti)), __LINE__);
        }
        $this->YFLUAAliciCariLimiti = $yFLUAAliciCariLimiti;
        return $this;
    }
    /**
     * Get YFLUAGonderenCariLimiti value
     * @return float
     */
    public function getYFLUAGonderenCariLimiti()
    {
        return $this->YFLUAGonderenCariLimiti;
    }
    /**
     * Set YFLUAGonderenCariLimiti value
     * @param float $yFLUAGonderenCariLimiti
     * @return \fk_\StructType\KSozlesme
     */
    public function setYFLUAGonderenCariLimiti($yFLUAGonderenCariLimiti = null)
    {
        // validation for constraint: float
        if (!is_null($yFLUAGonderenCariLimiti) && !(is_float($yFLUAGonderenCariLimiti) || is_numeric($yFLUAGonderenCariLimiti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($yFLUAGonderenCariLimiti, true), gettype($yFLUAGonderenCariLimiti)), __LINE__);
        }
        $this->YFLUAGonderenCariLimiti = $yFLUAGonderenCariLimiti;
        return $this;
    }
    /**
     * Get IsUADaKullan value
     * @return bool
     */
    public function getIsUADaKullan()
    {
        return $this->IsUADaKullan;
    }
    /**
     * Set IsUADaKullan value
     * @param bool $isUADaKullan
     * @return \fk_\StructType\KSozlesme
     */
    public function setIsUADaKullan($isUADaKullan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUADaKullan) && !is_bool($isUADaKullan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUADaKullan, true), gettype($isUADaKullan)), __LINE__);
        }
        $this->IsUADaKullan = $isUADaKullan;
        return $this;
    }
    /**
     * Get IsUAvrakKabulEdiliyor value
     * @return bool
     */
    public function getIsUAvrakKabulEdiliyor()
    {
        return $this->IsUAvrakKabulEdiliyor;
    }
    /**
     * Set IsUAvrakKabulEdiliyor value
     * @param bool $isUAvrakKabulEdiliyor
     * @return \fk_\StructType\KSozlesme
     */
    public function setIsUAvrakKabulEdiliyor($isUAvrakKabulEdiliyor = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUAvrakKabulEdiliyor) && !is_bool($isUAvrakKabulEdiliyor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUAvrakKabulEdiliyor, true), gettype($isUAvrakKabulEdiliyor)), __LINE__);
        }
        $this->IsUAvrakKabulEdiliyor = $isUAvrakKabulEdiliyor;
        return $this;
    }
    /**
     * Get TesellumFaturalamaDonemi value
     * @return string
     */
    public function getTesellumFaturalamaDonemi()
    {
        return $this->TesellumFaturalamaDonemi;
    }
    /**
     * Set TesellumFaturalamaDonemi value
     * @uses \fk_\EnumType\KIslemPeriodu::valueIsValid()
     * @uses \fk_\EnumType\KIslemPeriodu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tesellumFaturalamaDonemi
     * @return \fk_\StructType\KSozlesme
     */
    public function setTesellumFaturalamaDonemi($tesellumFaturalamaDonemi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KIslemPeriodu::valueIsValid($tesellumFaturalamaDonemi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KIslemPeriodu', is_array($tesellumFaturalamaDonemi) ? implode(', ', $tesellumFaturalamaDonemi) : var_export($tesellumFaturalamaDonemi, true), implode(', ', \fk_\EnumType\KIslemPeriodu::getValidValues())), __LINE__);
        }
        $this->TesellumFaturalamaDonemi = $tesellumFaturalamaDonemi;
        return $this;
    }
    /**
     * Get Limit value
     * @return float
     */
    public function getLimit()
    {
        return $this->Limit;
    }
    /**
     * Set Limit value
     * @param float $limit
     * @return \fk_\StructType\KSozlesme
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: float
        if (!is_null($limit) && !(is_float($limit) || is_numeric($limit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($limit, true), gettype($limit)), __LINE__);
        }
        $this->Limit = $limit;
        return $this;
    }
    /**
     * Get OdemePlani value
     * @return string
     */
    public function getOdemePlani()
    {
        return $this->OdemePlani;
    }
    /**
     * Set OdemePlani value
     * @uses \fk_\EnumType\KOdemePlani::valueIsValid()
     * @uses \fk_\EnumType\KOdemePlani::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemePlani
     * @return \fk_\StructType\KSozlesme
     */
    public function setOdemePlani($odemePlani = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KOdemePlani::valueIsValid($odemePlani)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KOdemePlani', is_array($odemePlani) ? implode(', ', $odemePlani) : var_export($odemePlani, true), implode(', ', \fk_\EnumType\KOdemePlani::getValidValues())), __LINE__);
        }
        $this->OdemePlani = $odemePlani;
        return $this;
    }
    /**
     * Get HaftaGun value
     * @return string
     */
    public function getHaftaGun()
    {
        return $this->HaftaGun;
    }
    /**
     * Set HaftaGun value
     * @uses \fk_\EnumType\KGunler::valueIsValid()
     * @uses \fk_\EnumType\KGunler::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $haftaGun
     * @return \fk_\StructType\KSozlesme
     */
    public function setHaftaGun($haftaGun = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KGunler::valueIsValid($haftaGun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KGunler', is_array($haftaGun) ? implode(', ', $haftaGun) : var_export($haftaGun, true), implode(', ', \fk_\EnumType\KGunler::getValidValues())), __LINE__);
        }
        $this->HaftaGun = $haftaGun;
        return $this;
    }
    /**
     * Get Aygun value
     * @return int
     */
    public function getAygun()
    {
        return $this->Aygun;
    }
    /**
     * Set Aygun value
     * @param int $aygun
     * @return \fk_\StructType\KSozlesme
     */
    public function setAygun($aygun = null)
    {
        // validation for constraint: int
        if (!is_null($aygun) && !(is_int($aygun) || ctype_digit($aygun))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aygun, true), gettype($aygun)), __LINE__);
        }
        $this->Aygun = $aygun;
        return $this;
    }
    /**
     * Get OdemeTipi value
     * @return string
     */
    public function getOdemeTipi()
    {
        return $this->OdemeTipi;
    }
    /**
     * Set OdemeTipi value
     * @uses \fk_\EnumType\KOdemeTipi::valueIsValid()
     * @uses \fk_\EnumType\KOdemeTipi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeTipi
     * @return \fk_\StructType\KSozlesme
     */
    public function setOdemeTipi($odemeTipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KOdemeTipi::valueIsValid($odemeTipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KOdemeTipi', is_array($odemeTipi) ? implode(', ', $odemeTipi) : var_export($odemeTipi, true), implode(', ', \fk_\EnumType\KOdemeTipi::getValidValues())), __LINE__);
        }
        $this->OdemeTipi = $odemeTipi;
        return $this;
    }
    /**
     * Get CekVadesi value
     * @return int
     */
    public function getCekVadesi()
    {
        return $this->CekVadesi;
    }
    /**
     * Set CekVadesi value
     * @param int $cekVadesi
     * @return \fk_\StructType\KSozlesme
     */
    public function setCekVadesi($cekVadesi = null)
    {
        // validation for constraint: int
        if (!is_null($cekVadesi) && !(is_int($cekVadesi) || ctype_digit($cekVadesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cekVadesi, true), gettype($cekVadesi)), __LINE__);
        }
        $this->CekVadesi = $cekVadesi;
        return $this;
    }
    /**
     * Get CariBakiye value
     * @return float
     */
    public function getCariBakiye()
    {
        return $this->CariBakiye;
    }
    /**
     * Set CariBakiye value
     * @param float $cariBakiye
     * @return \fk_\StructType\KSozlesme
     */
    public function setCariBakiye($cariBakiye = null)
    {
        // validation for constraint: float
        if (!is_null($cariBakiye) && !(is_float($cariBakiye) || is_numeric($cariBakiye))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cariBakiye, true), gettype($cariBakiye)), __LINE__);
        }
        $this->CariBakiye = $cariBakiye;
        return $this;
    }
    /**
     * Get LimitAsimTarihi value
     * @return string
     */
    public function getLimitAsimTarihi()
    {
        return $this->LimitAsimTarihi;
    }
    /**
     * Set LimitAsimTarihi value
     * @param string $limitAsimTarihi
     * @return \fk_\StructType\KSozlesme
     */
    public function setLimitAsimTarihi($limitAsimTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($limitAsimTarihi) && !is_string($limitAsimTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($limitAsimTarihi, true), gettype($limitAsimTarihi)), __LINE__);
        }
        $this->LimitAsimTarihi = $limitAsimTarihi;
        return $this;
    }
    /**
     * Get MinimumOdemeTutarYuzdesi value
     * @return int
     */
    public function getMinimumOdemeTutarYuzdesi()
    {
        return $this->MinimumOdemeTutarYuzdesi;
    }
    /**
     * Set MinimumOdemeTutarYuzdesi value
     * @param int $minimumOdemeTutarYuzdesi
     * @return \fk_\StructType\KSozlesme
     */
    public function setMinimumOdemeTutarYuzdesi($minimumOdemeTutarYuzdesi = null)
    {
        // validation for constraint: int
        if (!is_null($minimumOdemeTutarYuzdesi) && !(is_int($minimumOdemeTutarYuzdesi) || ctype_digit($minimumOdemeTutarYuzdesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumOdemeTutarYuzdesi, true), gettype($minimumOdemeTutarYuzdesi)), __LINE__);
        }
        $this->MinimumOdemeTutarYuzdesi = $minimumOdemeTutarYuzdesi;
        return $this;
    }
    /**
     * Get MinumumOdemeTutari value
     * @return float
     */
    public function getMinumumOdemeTutari()
    {
        return $this->MinumumOdemeTutari;
    }
    /**
     * Set MinumumOdemeTutari value
     * @param float $minumumOdemeTutari
     * @return \fk_\StructType\KSozlesme
     */
    public function setMinumumOdemeTutari($minumumOdemeTutari = null)
    {
        // validation for constraint: float
        if (!is_null($minumumOdemeTutari) && !(is_float($minumumOdemeTutari) || is_numeric($minumumOdemeTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minumumOdemeTutari, true), gettype($minumumOdemeTutari)), __LINE__);
        }
        $this->MinumumOdemeTutari = $minumumOdemeTutari;
        return $this;
    }
    /**
     * Get RiskLimitiIzinVerenBirim value
     * @return string
     */
    public function getRiskLimitiIzinVerenBirim()
    {
        return $this->RiskLimitiIzinVerenBirim;
    }
    /**
     * Set RiskLimitiIzinVerenBirim value
     * @uses \fk_\EnumType\IzinVerenBirim::valueIsValid()
     * @uses \fk_\EnumType\IzinVerenBirim::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $riskLimitiIzinVerenBirim
     * @return \fk_\StructType\KSozlesme
     */
    public function setRiskLimitiIzinVerenBirim($riskLimitiIzinVerenBirim = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\IzinVerenBirim::valueIsValid($riskLimitiIzinVerenBirim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\IzinVerenBirim', is_array($riskLimitiIzinVerenBirim) ? implode(', ', $riskLimitiIzinVerenBirim) : var_export($riskLimitiIzinVerenBirim, true), implode(', ', \fk_\EnumType\IzinVerenBirim::getValidValues())), __LINE__);
        }
        $this->RiskLimitiIzinVerenBirim = $riskLimitiIzinVerenBirim;
        return $this;
    }
    /**
     * Get OdemePlaniIzinVerenBirim value
     * @return string
     */
    public function getOdemePlaniIzinVerenBirim()
    {
        return $this->OdemePlaniIzinVerenBirim;
    }
    /**
     * Set OdemePlaniIzinVerenBirim value
     * @uses \fk_\EnumType\IzinVerenBirim::valueIsValid()
     * @uses \fk_\EnumType\IzinVerenBirim::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemePlaniIzinVerenBirim
     * @return \fk_\StructType\KSozlesme
     */
    public function setOdemePlaniIzinVerenBirim($odemePlaniIzinVerenBirim = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\IzinVerenBirim::valueIsValid($odemePlaniIzinVerenBirim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\IzinVerenBirim', is_array($odemePlaniIzinVerenBirim) ? implode(', ', $odemePlaniIzinVerenBirim) : var_export($odemePlaniIzinVerenBirim, true), implode(', ', \fk_\EnumType\IzinVerenBirim::getValidValues())), __LINE__);
        }
        $this->OdemePlaniIzinVerenBirim = $odemePlaniIzinVerenBirim;
        return $this;
    }
    /**
     * Get EkOdemeGunu value
     * @return int
     */
    public function getEkOdemeGunu()
    {
        return $this->EkOdemeGunu;
    }
    /**
     * Set EkOdemeGunu value
     * @param int $ekOdemeGunu
     * @return \fk_\StructType\KSozlesme
     */
    public function setEkOdemeGunu($ekOdemeGunu = null)
    {
        // validation for constraint: int
        if (!is_null($ekOdemeGunu) && !(is_int($ekOdemeGunu) || ctype_digit($ekOdemeGunu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ekOdemeGunu, true), gettype($ekOdemeGunu)), __LINE__);
        }
        $this->EkOdemeGunu = $ekOdemeGunu;
        return $this;
    }
    /**
     * Get EkLimitGunu value
     * @return int
     */
    public function getEkLimitGunu()
    {
        return $this->EkLimitGunu;
    }
    /**
     * Set EkLimitGunu value
     * @param int $ekLimitGunu
     * @return \fk_\StructType\KSozlesme
     */
    public function setEkLimitGunu($ekLimitGunu = null)
    {
        // validation for constraint: int
        if (!is_null($ekLimitGunu) && !(is_int($ekLimitGunu) || ctype_digit($ekLimitGunu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ekLimitGunu, true), gettype($ekLimitGunu)), __LINE__);
        }
        $this->EkLimitGunu = $ekLimitGunu;
        return $this;
    }
    /**
     * Get IlkOdemeTarihi value
     * @return string
     */
    public function getIlkOdemeTarihi()
    {
        return $this->IlkOdemeTarihi;
    }
    /**
     * Set IlkOdemeTarihi value
     * @param string $ilkOdemeTarihi
     * @return \fk_\StructType\KSozlesme
     */
    public function setIlkOdemeTarihi($ilkOdemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($ilkOdemeTarihi) && !is_string($ilkOdemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ilkOdemeTarihi, true), gettype($ilkOdemeTarihi)), __LINE__);
        }
        $this->IlkOdemeTarihi = $ilkOdemeTarihi;
        return $this;
    }
    /**
     * Get SonOdemeTarihi value
     * @return string
     */
    public function getSonOdemeTarihi()
    {
        return $this->SonOdemeTarihi;
    }
    /**
     * Set SonOdemeTarihi value
     * @param string $sonOdemeTarihi
     * @return \fk_\StructType\KSozlesme
     */
    public function setSonOdemeTarihi($sonOdemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($sonOdemeTarihi) && !is_string($sonOdemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sonOdemeTarihi, true), gettype($sonOdemeTarihi)), __LINE__);
        }
        $this->SonOdemeTarihi = $sonOdemeTarihi;
        return $this;
    }
    /**
     * Get ErtelenenLimitTarihi value
     * @return string
     */
    public function getErtelenenLimitTarihi()
    {
        return $this->ErtelenenLimitTarihi;
    }
    /**
     * Set ErtelenenLimitTarihi value
     * @param string $ertelenenLimitTarihi
     * @return \fk_\StructType\KSozlesme
     */
    public function setErtelenenLimitTarihi($ertelenenLimitTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($ertelenenLimitTarihi) && !is_string($ertelenenLimitTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ertelenenLimitTarihi, true), gettype($ertelenenLimitTarihi)), __LINE__);
        }
        $this->ErtelenenLimitTarihi = $ertelenenLimitTarihi;
        return $this;
    }
    /**
     * Get ErtelenenOdemeTarihi value
     * @return string
     */
    public function getErtelenenOdemeTarihi()
    {
        return $this->ErtelenenOdemeTarihi;
    }
    /**
     * Set ErtelenenOdemeTarihi value
     * @param string $ertelenenOdemeTarihi
     * @return \fk_\StructType\KSozlesme
     */
    public function setErtelenenOdemeTarihi($ertelenenOdemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($ertelenenOdemeTarihi) && !is_string($ertelenenOdemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ertelenenOdemeTarihi, true), gettype($ertelenenOdemeTarihi)), __LINE__);
        }
        $this->ErtelenenOdemeTarihi = $ertelenenOdemeTarihi;
        return $this;
    }
    /**
     * Get IsOnOnay value
     * @return bool
     */
    public function getIsOnOnay()
    {
        return $this->IsOnOnay;
    }
    /**
     * Set IsOnOnay value
     * @param bool $isOnOnay
     * @return \fk_\StructType\KSozlesme
     */
    public function setIsOnOnay($isOnOnay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnOnay) && !is_bool($isOnOnay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnOnay, true), gettype($isOnOnay)), __LINE__);
        }
        $this->IsOnOnay = $isOnOnay;
        return $this;
    }
    /**
     * Get SozlesmeGecerliBasTar value
     * @return string
     */
    public function getSozlesmeGecerliBasTar()
    {
        return $this->SozlesmeGecerliBasTar;
    }
    /**
     * Set SozlesmeGecerliBasTar value
     * @param string $sozlesmeGecerliBasTar
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeGecerliBasTar($sozlesmeGecerliBasTar = null)
    {
        // validation for constraint: string
        if (!is_null($sozlesmeGecerliBasTar) && !is_string($sozlesmeGecerliBasTar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sozlesmeGecerliBasTar, true), gettype($sozlesmeGecerliBasTar)), __LINE__);
        }
        $this->SozlesmeGecerliBasTar = $sozlesmeGecerliBasTar;
        return $this;
    }
    /**
     * Get TahsilatUcreti value
     * @return float
     */
    public function getTahsilatUcreti()
    {
        return $this->TahsilatUcreti;
    }
    /**
     * Set TahsilatUcreti value
     * @param float $tahsilatUcreti
     * @return \fk_\StructType\KSozlesme
     */
    public function setTahsilatUcreti($tahsilatUcreti = null)
    {
        // validation for constraint: float
        if (!is_null($tahsilatUcreti) && !(is_float($tahsilatUcreti) || is_numeric($tahsilatUcreti))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tahsilatUcreti, true), gettype($tahsilatUcreti)), __LINE__);
        }
        $this->TahsilatUcreti = $tahsilatUcreti;
        return $this;
    }
    /**
     * Get KolibasiIndirimBasAdet value
     * @return int
     */
    public function getKolibasiIndirimBasAdet()
    {
        return $this->KolibasiIndirimBasAdet;
    }
    /**
     * Set KolibasiIndirimBasAdet value
     * @param int $kolibasiIndirimBasAdet
     * @return \fk_\StructType\KSozlesme
     */
    public function setKolibasiIndirimBasAdet($kolibasiIndirimBasAdet = null)
    {
        // validation for constraint: int
        if (!is_null($kolibasiIndirimBasAdet) && !(is_int($kolibasiIndirimBasAdet) || ctype_digit($kolibasiIndirimBasAdet))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kolibasiIndirimBasAdet, true), gettype($kolibasiIndirimBasAdet)), __LINE__);
        }
        $this->KolibasiIndirimBasAdet = $kolibasiIndirimBasAdet;
        return $this;
    }
    /**
     * Get KolibasiIndirimOrani value
     * @return float
     */
    public function getKolibasiIndirimOrani()
    {
        return $this->KolibasiIndirimOrani;
    }
    /**
     * Set KolibasiIndirimOrani value
     * @param float $kolibasiIndirimOrani
     * @return \fk_\StructType\KSozlesme
     */
    public function setKolibasiIndirimOrani($kolibasiIndirimOrani = null)
    {
        // validation for constraint: float
        if (!is_null($kolibasiIndirimOrani) && !(is_float($kolibasiIndirimOrani) || is_numeric($kolibasiIndirimOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kolibasiIndirimOrani, true), gettype($kolibasiIndirimOrani)), __LINE__);
        }
        $this->KolibasiIndirimOrani = $kolibasiIndirimOrani;
        return $this;
    }
    /**
     * Get KOLimit value
     * @return float
     */
    public function getKOLimit()
    {
        return $this->KOLimit;
    }
    /**
     * Set KOLimit value
     * @param float $kOLimit
     * @return \fk_\StructType\KSozlesme
     */
    public function setKOLimit($kOLimit = null)
    {
        // validation for constraint: float
        if (!is_null($kOLimit) && !(is_float($kOLimit) || is_numeric($kOLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kOLimit, true), gettype($kOLimit)), __LINE__);
        }
        $this->KOLimit = $kOLimit;
        return $this;
    }
    /**
     * Get KOBarajTutari value
     * @return float
     */
    public function getKOBarajTutari()
    {
        return $this->KOBarajTutari;
    }
    /**
     * Set KOBarajTutari value
     * @param float $kOBarajTutari
     * @return \fk_\StructType\KSozlesme
     */
    public function setKOBarajTutari($kOBarajTutari = null)
    {
        // validation for constraint: float
        if (!is_null($kOBarajTutari) && !(is_float($kOBarajTutari) || is_numeric($kOBarajTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kOBarajTutari, true), gettype($kOBarajTutari)), __LINE__);
        }
        $this->KOBarajTutari = $kOBarajTutari;
        return $this;
    }
    /**
     * Get KOBarajUstuOran value
     * @return float
     */
    public function getKOBarajUstuOran()
    {
        return $this->KOBarajUstuOran;
    }
    /**
     * Set KOBarajUstuOran value
     * @param float $kOBarajUstuOran
     * @return \fk_\StructType\KSozlesme
     */
    public function setKOBarajUstuOran($kOBarajUstuOran = null)
    {
        // validation for constraint: float
        if (!is_null($kOBarajUstuOran) && !(is_float($kOBarajUstuOran) || is_numeric($kOBarajUstuOran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kOBarajUstuOran, true), gettype($kOBarajUstuOran)), __LINE__);
        }
        $this->KOBarajUstuOran = $kOBarajUstuOran;
        return $this;
    }
    /**
     * Get FiyatHesaplamaKriteri value
     * @return string
     */
    public function getFiyatHesaplamaKriteri()
    {
        return $this->FiyatHesaplamaKriteri;
    }
    /**
     * Set FiyatHesaplamaKriteri value
     * @uses \fk_\EnumType\KSozlesmeFiyatHesaplamaKriteri::valueIsValid()
     * @uses \fk_\EnumType\KSozlesmeFiyatHesaplamaKriteri::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fiyatHesaplamaKriteri
     * @return \fk_\StructType\KSozlesme
     */
    public function setFiyatHesaplamaKriteri($fiyatHesaplamaKriteri = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KSozlesmeFiyatHesaplamaKriteri::valueIsValid($fiyatHesaplamaKriteri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KSozlesmeFiyatHesaplamaKriteri', is_array($fiyatHesaplamaKriteri) ? implode(', ', $fiyatHesaplamaKriteri) : var_export($fiyatHesaplamaKriteri, true), implode(', ', \fk_\EnumType\KSozlesmeFiyatHesaplamaKriteri::getValidValues())), __LINE__);
        }
        $this->FiyatHesaplamaKriteri = $fiyatHesaplamaKriteri;
        return $this;
    }
    /**
     * Get KOPosCozumGunSayisi value
     * @return int
     */
    public function getKOPosCozumGunSayisi()
    {
        return $this->KOPosCozumGunSayisi;
    }
    /**
     * Set KOPosCozumGunSayisi value
     * @param int $kOPosCozumGunSayisi
     * @return \fk_\StructType\KSozlesme
     */
    public function setKOPosCozumGunSayisi($kOPosCozumGunSayisi = null)
    {
        // validation for constraint: int
        if (!is_null($kOPosCozumGunSayisi) && !(is_int($kOPosCozumGunSayisi) || ctype_digit($kOPosCozumGunSayisi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kOPosCozumGunSayisi, true), gettype($kOPosCozumGunSayisi)), __LINE__);
        }
        $this->KOPosCozumGunSayisi = $kOPosCozumGunSayisi;
        return $this;
    }
    /**
     * Get SozlesmeArtisOraniDurumu value
     * @return string
     */
    public function getSozlesmeArtisOraniDurumu()
    {
        return $this->SozlesmeArtisOraniDurumu;
    }
    /**
     * Set SozlesmeArtisOraniDurumu value
     * @uses \fk_\EnumType\SozlesmeArtisOrani::valueIsValid()
     * @uses \fk_\EnumType\SozlesmeArtisOrani::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sozlesmeArtisOraniDurumu
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeArtisOraniDurumu($sozlesmeArtisOraniDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\SozlesmeArtisOrani::valueIsValid($sozlesmeArtisOraniDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\SozlesmeArtisOrani', is_array($sozlesmeArtisOraniDurumu) ? implode(', ', $sozlesmeArtisOraniDurumu) : var_export($sozlesmeArtisOraniDurumu, true), implode(', ', \fk_\EnumType\SozlesmeArtisOrani::getValidValues())), __LINE__);
        }
        $this->SozlesmeArtisOraniDurumu = $sozlesmeArtisOraniDurumu;
        return $this;
    }
    /**
     * Get TesellumTutariGorunmesin value
     * @return bool
     */
    public function getTesellumTutariGorunmesin()
    {
        return $this->TesellumTutariGorunmesin;
    }
    /**
     * Set TesellumTutariGorunmesin value
     * @param bool $tesellumTutariGorunmesin
     * @return \fk_\StructType\KSozlesme
     */
    public function setTesellumTutariGorunmesin($tesellumTutariGorunmesin = null)
    {
        // validation for constraint: boolean
        if (!is_null($tesellumTutariGorunmesin) && !is_bool($tesellumTutariGorunmesin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tesellumTutariGorunmesin, true), gettype($tesellumTutariGorunmesin)), __LINE__);
        }
        $this->TesellumTutariGorunmesin = $tesellumTutariGorunmesin;
        return $this;
    }
    /**
     * Get ErkenOdemeYuzdesi value
     * @return float
     */
    public function getErkenOdemeYuzdesi()
    {
        return $this->ErkenOdemeYuzdesi;
    }
    /**
     * Set ErkenOdemeYuzdesi value
     * @param float $erkenOdemeYuzdesi
     * @return \fk_\StructType\KSozlesme
     */
    public function setErkenOdemeYuzdesi($erkenOdemeYuzdesi = null)
    {
        // validation for constraint: float
        if (!is_null($erkenOdemeYuzdesi) && !(is_float($erkenOdemeYuzdesi) || is_numeric($erkenOdemeYuzdesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($erkenOdemeYuzdesi, true), gettype($erkenOdemeYuzdesi)), __LINE__);
        }
        $this->ErkenOdemeYuzdesi = $erkenOdemeYuzdesi;
        return $this;
    }
    /**
     * Get KOAHEkHizmetDurumu value
     * @return string
     */
    public function getKOAHEkHizmetDurumu()
    {
        return $this->KOAHEkHizmetDurumu;
    }
    /**
     * Set KOAHEkHizmetDurumu value
     * @uses \fk_\EnumType\KOAHEkHizmetDurumu::valueIsValid()
     * @uses \fk_\EnumType\KOAHEkHizmetDurumu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kOAHEkHizmetDurumu
     * @return \fk_\StructType\KSozlesme
     */
    public function setKOAHEkHizmetDurumu($kOAHEkHizmetDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KOAHEkHizmetDurumu::valueIsValid($kOAHEkHizmetDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KOAHEkHizmetDurumu', is_array($kOAHEkHizmetDurumu) ? implode(', ', $kOAHEkHizmetDurumu) : var_export($kOAHEkHizmetDurumu, true), implode(', ', \fk_\EnumType\KOAHEkHizmetDurumu::getValidValues())), __LINE__);
        }
        $this->KOAHEkHizmetDurumu = $kOAHEkHizmetDurumu;
        return $this;
    }
    /**
     * Get IsGittiGidiyorCarisi value
     * @return bool
     */
    public function getIsGittiGidiyorCarisi()
    {
        return $this->IsGittiGidiyorCarisi;
    }
    /**
     * Set IsGittiGidiyorCarisi value
     * @param bool $isGittiGidiyorCarisi
     * @return \fk_\StructType\KSozlesme
     */
    public function setIsGittiGidiyorCarisi($isGittiGidiyorCarisi = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGittiGidiyorCarisi) && !is_bool($isGittiGidiyorCarisi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGittiGidiyorCarisi, true), gettype($isGittiGidiyorCarisi)), __LINE__);
        }
        $this->IsGittiGidiyorCarisi = $isGittiGidiyorCarisi;
        return $this;
    }
    /**
     * Get GittiGidiyorVirmanTutari value
     * @return float
     */
    public function getGittiGidiyorVirmanTutari()
    {
        return $this->GittiGidiyorVirmanTutari;
    }
    /**
     * Set GittiGidiyorVirmanTutari value
     * @param float $gittiGidiyorVirmanTutari
     * @return \fk_\StructType\KSozlesme
     */
    public function setGittiGidiyorVirmanTutari($gittiGidiyorVirmanTutari = null)
    {
        // validation for constraint: float
        if (!is_null($gittiGidiyorVirmanTutari) && !(is_float($gittiGidiyorVirmanTutari) || is_numeric($gittiGidiyorVirmanTutari))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gittiGidiyorVirmanTutari, true), gettype($gittiGidiyorVirmanTutari)), __LINE__);
        }
        $this->GittiGidiyorVirmanTutari = $gittiGidiyorVirmanTutari;
        return $this;
    }
    /**
     * Get SozlesmeKaynagi value
     * @return string
     */
    public function getSozlesmeKaynagi()
    {
        return $this->SozlesmeKaynagi;
    }
    /**
     * Set SozlesmeKaynagi value
     * @uses \fk_\EnumType\SozlesmeKaynagi::valueIsValid()
     * @uses \fk_\EnumType\SozlesmeKaynagi::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sozlesmeKaynagi
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeKaynagi($sozlesmeKaynagi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\SozlesmeKaynagi::valueIsValid($sozlesmeKaynagi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\SozlesmeKaynagi', is_array($sozlesmeKaynagi) ? implode(', ', $sozlesmeKaynagi) : var_export($sozlesmeKaynagi, true), implode(', ', \fk_\EnumType\SozlesmeKaynagi::getValidValues())), __LINE__);
        }
        $this->SozlesmeKaynagi = $sozlesmeKaynagi;
        return $this;
    }
    /**
     * Get OdemeGunu value
     * @return int
     */
    public function getOdemeGunu()
    {
        return $this->OdemeGunu;
    }
    /**
     * Set OdemeGunu value
     * @param int $odemeGunu
     * @return \fk_\StructType\KSozlesme
     */
    public function setOdemeGunu($odemeGunu = null)
    {
        // validation for constraint: int
        if (!is_null($odemeGunu) && !(is_int($odemeGunu) || ctype_digit($odemeGunu))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($odemeGunu, true), gettype($odemeGunu)), __LINE__);
        }
        $this->OdemeGunu = $odemeGunu;
        return $this;
    }
    /**
     * Get IsTurkiyeGeneliGecerliOlsun value
     * @return bool
     */
    public function getIsTurkiyeGeneliGecerliOlsun()
    {
        return $this->IsTurkiyeGeneliGecerliOlsun;
    }
    /**
     * Set IsTurkiyeGeneliGecerliOlsun value
     * @param bool $isTurkiyeGeneliGecerliOlsun
     * @return \fk_\StructType\KSozlesme
     */
    public function setIsTurkiyeGeneliGecerliOlsun($isTurkiyeGeneliGecerliOlsun = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTurkiyeGeneliGecerliOlsun) && !is_bool($isTurkiyeGeneliGecerliOlsun)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTurkiyeGeneliGecerliOlsun, true), gettype($isTurkiyeGeneliGecerliOlsun)), __LINE__);
        }
        $this->IsTurkiyeGeneliGecerliOlsun = $isTurkiyeGeneliGecerliOlsun;
        return $this;
    }
    /**
     * Get IsEphHesaplansin value
     * @return bool
     */
    public function getIsEphHesaplansin()
    {
        return $this->IsEphHesaplansin;
    }
    /**
     * Set IsEphHesaplansin value
     * @param bool $isEphHesaplansin
     * @return \fk_\StructType\KSozlesme
     */
    public function setIsEphHesaplansin($isEphHesaplansin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEphHesaplansin) && !is_bool($isEphHesaplansin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEphHesaplansin, true), gettype($isEphHesaplansin)), __LINE__);
        }
        $this->IsEphHesaplansin = $isEphHesaplansin;
        return $this;
    }
    /**
     * Get UcretsizSmsKullansin value
     * @return bool
     */
    public function getUcretsizSmsKullansin()
    {
        return $this->UcretsizSmsKullansin;
    }
    /**
     * Set UcretsizSmsKullansin value
     * @param bool $ucretsizSmsKullansin
     * @return \fk_\StructType\KSozlesme
     */
    public function setUcretsizSmsKullansin($ucretsizSmsKullansin = null)
    {
        // validation for constraint: boolean
        if (!is_null($ucretsizSmsKullansin) && !is_bool($ucretsizSmsKullansin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ucretsizSmsKullansin, true), gettype($ucretsizSmsKullansin)), __LINE__);
        }
        $this->UcretsizSmsKullansin = $ucretsizSmsKullansin;
        return $this;
    }
    /**
     * Get Onaymi value
     * @return bool
     */
    public function getOnaymi()
    {
        return $this->Onaymi;
    }
    /**
     * Set Onaymi value
     * @param bool $onaymi
     * @return \fk_\StructType\KSozlesme
     */
    public function setOnaymi($onaymi = null)
    {
        // validation for constraint: boolean
        if (!is_null($onaymi) && !is_bool($onaymi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onaymi, true), gettype($onaymi)), __LINE__);
        }
        $this->Onaymi = $onaymi;
        return $this;
    }
    /**
     * Get HizmetKDVsiKullan value
     * @return bool
     */
    public function getHizmetKDVsiKullan()
    {
        return $this->HizmetKDVsiKullan;
    }
    /**
     * Set HizmetKDVsiKullan value
     * @param bool $hizmetKDVsiKullan
     * @return \fk_\StructType\KSozlesme
     */
    public function setHizmetKDVsiKullan($hizmetKDVsiKullan = null)
    {
        // validation for constraint: boolean
        if (!is_null($hizmetKDVsiKullan) && !is_bool($hizmetKDVsiKullan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hizmetKDVsiKullan, true), gettype($hizmetKDVsiKullan)), __LINE__);
        }
        $this->HizmetKDVsiKullan = $hizmetKDVsiKullan;
        return $this;
    }
    /**
     * Get TahsilatVadesi value
     * @return int
     */
    public function getTahsilatVadesi()
    {
        return $this->TahsilatVadesi;
    }
    /**
     * Set TahsilatVadesi value
     * @param int $tahsilatVadesi
     * @return \fk_\StructType\KSozlesme
     */
    public function setTahsilatVadesi($tahsilatVadesi = null)
    {
        // validation for constraint: int
        if (!is_null($tahsilatVadesi) && !(is_int($tahsilatVadesi) || ctype_digit($tahsilatVadesi))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tahsilatVadesi, true), gettype($tahsilatVadesi)), __LINE__);
        }
        $this->TahsilatVadesi = $tahsilatVadesi;
        return $this;
    }
    /**
     * Get Hizmeti value
     * @return \fk_\StructType\KHizmetPointer|null
     */
    public function getHizmeti()
    {
        return $this->Hizmeti;
    }
    /**
     * Set Hizmeti value
     * @param \fk_\StructType\KHizmetPointer $hizmeti
     * @return \fk_\StructType\KSozlesme
     */
    public function setHizmeti(\fk_\StructType\KHizmetPointer $hizmeti = null)
    {
        $this->Hizmeti = $hizmeti;
        return $this;
    }
    /**
     * Get Carisi value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getCarisi()
    {
        return $this->Carisi;
    }
    /**
     * Set Carisi value
     * @param \fk_\StructType\KCariPointer $carisi
     * @return \fk_\StructType\KSozlesme
     */
    public function setCarisi(\fk_\StructType\KCariPointer $carisi = null)
    {
        $this->Carisi = $carisi;
        return $this;
    }
    /**
     * Get Revizyonu value
     * @return \fk_\StructType\KSozlesmePointer|null
     */
    public function getRevizyonu()
    {
        return $this->Revizyonu;
    }
    /**
     * Set Revizyonu value
     * @param \fk_\StructType\KSozlesmePointer $revizyonu
     * @return \fk_\StructType\KSozlesme
     */
    public function setRevizyonu(\fk_\StructType\KSozlesmePointer $revizyonu = null)
    {
        $this->Revizyonu = $revizyonu;
        return $this;
    }
    /**
     * Get Sube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getSube()
    {
        return $this->Sube;
    }
    /**
     * Set Sube value
     * @param \fk_\StructType\KSubePointer $sube
     * @return \fk_\StructType\KSozlesme
     */
    public function setSube(\fk_\StructType\KSubePointer $sube = null)
    {
        $this->Sube = $sube;
        return $this;
    }
    /**
     * Get SozlesmeRef value
     * @return \fk_\StructType\KSozlesmePointer|null
     */
    public function getSozlesmeRef()
    {
        return $this->SozlesmeRef;
    }
    /**
     * Set SozlesmeRef value
     * @param \fk_\StructType\KSozlesmePointer $sozlesmeRef
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeRef(\fk_\StructType\KSozlesmePointer $sozlesmeRef = null)
    {
        $this->SozlesmeRef = $sozlesmeRef;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\KSozlesme
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get RedNeden value
     * @return string|null
     */
    public function getRedNeden()
    {
        return $this->RedNeden;
    }
    /**
     * Set RedNeden value
     * @param string $redNeden
     * @return \fk_\StructType\KSozlesme
     */
    public function setRedNeden($redNeden = null)
    {
        // validation for constraint: string
        if (!is_null($redNeden) && !is_string($redNeden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redNeden, true), gettype($redNeden)), __LINE__);
        }
        $this->RedNeden = $redNeden;
        return $this;
    }
    /**
     * Get Proje value
     * @return \fk_\StructType\KProjePointer|null
     */
    public function getProje()
    {
        return $this->Proje;
    }
    /**
     * Set Proje value
     * @param \fk_\StructType\KProjePointer $proje
     * @return \fk_\StructType\KSozlesme
     */
    public function setProje(\fk_\StructType\KProjePointer $proje = null)
    {
        $this->Proje = $proje;
        return $this;
    }
    /**
     * Get TahsilatSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getTahsilatSube()
    {
        return $this->TahsilatSube;
    }
    /**
     * Set TahsilatSube value
     * @param \fk_\StructType\KSubePointer $tahsilatSube
     * @return \fk_\StructType\KSozlesme
     */
    public function setTahsilatSube(\fk_\StructType\KSubePointer $tahsilatSube = null)
    {
        $this->TahsilatSube = $tahsilatSube;
        return $this;
    }
    /**
     * Get TesellumFaturalayacakSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getTesellumFaturalayacakSube()
    {
        return $this->TesellumFaturalayacakSube;
    }
    /**
     * Set TesellumFaturalayacakSube value
     * @param \fk_\StructType\KSubePointer $tesellumFaturalayacakSube
     * @return \fk_\StructType\KSozlesme
     */
    public function setTesellumFaturalayacakSube(\fk_\StructType\KSubePointer $tesellumFaturalayacakSube = null)
    {
        $this->TesellumFaturalayacakSube = $tesellumFaturalayacakSube;
        return $this;
    }
    /**
     * Get OdemeCari value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getOdemeCari()
    {
        return $this->OdemeCari;
    }
    /**
     * Set OdemeCari value
     * @param \fk_\StructType\KCariPointer $odemeCari
     * @return \fk_\StructType\KSozlesme
     */
    public function setOdemeCari(\fk_\StructType\KCariPointer $odemeCari = null)
    {
        $this->OdemeCari = $odemeCari;
        return $this;
    }
    /**
     * Get IslemDoviz value
     * @return \fk_\StructType\DovizTuruPointer|null
     */
    public function getIslemDoviz()
    {
        return $this->IslemDoviz;
    }
    /**
     * Set IslemDoviz value
     * @param \fk_\StructType\DovizTuruPointer $islemDoviz
     * @return \fk_\StructType\KSozlesme
     */
    public function setIslemDoviz(\fk_\StructType\DovizTuruPointer $islemDoviz = null)
    {
        $this->IslemDoviz = $islemDoviz;
        return $this;
    }
    /**
     * Get SozlesmeBolgeleri value
     * @return \fk_\ArrayType\ArrayOfKSozlesmeBolge|null
     */
    public function getSozlesmeBolgeleri()
    {
        return $this->SozlesmeBolgeleri;
    }
    /**
     * Set SozlesmeBolgeleri value
     * @param \fk_\ArrayType\ArrayOfKSozlesmeBolge $sozlesmeBolgeleri
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeBolgeleri(\fk_\ArrayType\ArrayOfKSozlesmeBolge $sozlesmeBolgeleri = null)
    {
        $this->SozlesmeBolgeleri = $sozlesmeBolgeleri;
        return $this;
    }
    /**
     * Get CekirdekCarisi value
     * @return \fk_\StructType\CariFisiPointer|null
     */
    public function getCekirdekCarisi()
    {
        return $this->CekirdekCarisi;
    }
    /**
     * Set CekirdekCarisi value
     * @param \fk_\StructType\CariFisiPointer $cekirdekCarisi
     * @return \fk_\StructType\KSozlesme
     */
    public function setCekirdekCarisi(\fk_\StructType\CariFisiPointer $cekirdekCarisi = null)
    {
        $this->CekirdekCarisi = $cekirdekCarisi;
        return $this;
    }
    /**
     * Get Firma value
     * @return \fk_\StructType\KYurtDisiFirmaTanimlamaPointer|null
     */
    public function getFirma()
    {
        return $this->Firma;
    }
    /**
     * Set Firma value
     * @param \fk_\StructType\KYurtDisiFirmaTanimlamaPointer $firma
     * @return \fk_\StructType\KSozlesme
     */
    public function setFirma(\fk_\StructType\KYurtDisiFirmaTanimlamaPointer $firma = null)
    {
        $this->Firma = $firma;
        return $this;
    }
    /**
     * Get SozlesmeMailleri value
     * @return \fk_\StructType\KCariMailPointer|null
     */
    public function getSozlesmeMailleri()
    {
        return $this->SozlesmeMailleri;
    }
    /**
     * Set SozlesmeMailleri value
     * @param \fk_\StructType\KCariMailPointer $sozlesmeMailleri
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeMailleri(\fk_\StructType\KCariMailPointer $sozlesmeMailleri = null)
    {
        $this->SozlesmeMailleri = $sozlesmeMailleri;
        return $this;
    }
    /**
     * Get SozlesmeyeDahilOlanGitGelEkHizmetleri value
     * @return \fk_\ArrayType\ArrayOfKEkHizmet|null
     */
    public function getSozlesmeyeDahilOlanGitGelEkHizmetleri()
    {
        return $this->SozlesmeyeDahilOlanGitGelEkHizmetleri;
    }
    /**
     * Set SozlesmeyeDahilOlanGitGelEkHizmetleri value
     * @param \fk_\ArrayType\ArrayOfKEkHizmet $sozlesmeyeDahilOlanGitGelEkHizmetleri
     * @return \fk_\StructType\KSozlesme
     */
    public function setSozlesmeyeDahilOlanGitGelEkHizmetleri(\fk_\ArrayType\ArrayOfKEkHizmet $sozlesmeyeDahilOlanGitGelEkHizmetleri = null)
    {
        $this->SozlesmeyeDahilOlanGitGelEkHizmetleri = $sozlesmeyeDahilOlanGitGelEkHizmetleri;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KSozlesme
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
