<?php

namespace fk_\EnumType;

/**
 * This class stands for KCariOzellik EnumType
 * @subpackage Enumerations
 */
class KCariOzellik
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Anlasmali'
     * @return string 'Anlasmali'
     */
    const VALUE_ANLASMALI = 'Anlasmali';
    /**
     * Constant for value 'Araci'
     * @return string 'Araci'
     */
    const VALUE_ARACI = 'Araci';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_ANLASMALI
     * @uses self::VALUE_ARACI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_ANLASMALI,
            self::VALUE_ARACI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
