<?php

namespace fk_\EnumType;

/**
 * This class stands for ZimmetDurum EnumType
 * @subpackage Enumerations
 */
class ZimmetDurum
{
    /**
     * Constant for value 'Aktif'
     * @return string 'Aktif'
     */
    const VALUE_AKTIF = 'Aktif';
    /**
     * Constant for value 'Kullanildi'
     * @return string 'Kullanildi'
     */
    const VALUE_KULLANILDI = 'Kullanildi';
    /**
     * Constant for value 'Kullanilmadi'
     * @return string 'Kullanilmadi'
     */
    const VALUE_KULLANILMADI = 'Kullanilmadi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AKTIF
     * @uses self::VALUE_KULLANILDI
     * @uses self::VALUE_KULLANILMADI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AKTIF,
            self::VALUE_KULLANILDI,
            self::VALUE_KULLANILMADI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
