<?php

namespace fk_\EnumType;

/**
 * This class stands for KKOTaksitDurum EnumType
 * @subpackage Enumerations
 */
class KKOTaksitDurum
{
    /**
     * Constant for value 'Seciniz'
     * @return string 'Seciniz'
     */
    const VALUE_SECINIZ = 'Seciniz';
    /**
     * Constant for value 'Bekliyor'
     * @return string 'Bekliyor'
     */
    const VALUE_BEKLIYOR = 'Bekliyor';
    /**
     * Constant for value 'Iptal'
     * @return string 'Iptal'
     */
    const VALUE_IPTAL = 'Iptal';
    /**
     * Constant for value 'Odendi'
     * @return string 'Odendi'
     */
    const VALUE_ODENDI = 'Odendi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SECINIZ
     * @uses self::VALUE_BEKLIYOR
     * @uses self::VALUE_IPTAL
     * @uses self::VALUE_ODENDI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SECINIZ,
            self::VALUE_BEKLIYOR,
            self::VALUE_IPTAL,
            self::VALUE_ODENDI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
