<?php

namespace fk_\EnumType;

/**
 * This class stands for KEvrakCariTipi EnumType
 * @subpackage Enumerations
 */
class KEvrakCariTipi
{
    /**
     * Constant for value 'SadeceGonderenCariVar'
     * @return string 'SadeceGonderenCariVar'
     */
    const VALUE_SADECE_GONDEREN_CARI_VAR = 'SadeceGonderenCariVar';
    /**
     * Constant for value 'GonderenVeAliciCariVar'
     * @return string 'GonderenVeAliciCariVar'
     */
    const VALUE_GONDEREN_VE_ALICI_CARI_VAR = 'GonderenVeAliciCariVar';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SADECE_GONDEREN_CARI_VAR
     * @uses self::VALUE_GONDEREN_VE_ALICI_CARI_VAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SADECE_GONDEREN_CARI_VAR,
            self::VALUE_GONDEREN_VE_ALICI_CARI_VAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
