<?php

namespace fk_\EnumType;

/**
 * This class stands for CariOzellik EnumType
 * @subpackage Enumerations
 */
class CariOzellik
{
    /**
     * Constant for value 'GrupIci'
     * @return string 'GrupIci'
     */
    const VALUE_GRUP_ICI = 'GrupIci';
    /**
     * Constant for value 'GrupDisi'
     * @return string 'GrupDisi'
     */
    const VALUE_GRUP_DISI = 'GrupDisi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GRUP_ICI
     * @uses self::VALUE_GRUP_DISI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GRUP_ICI,
            self::VALUE_GRUP_DISI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
