<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Hesap StructType
 * @subpackage Structs
 */
abstract class Hesap extends SerendipEntity
{
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The AcanIsYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\IsYeriPointer
     */
    public $AcanIsYeri;
    /**
     * The AcanBolum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\BolumPointer
     */
    public $AcanBolum;
    /**
     * The HesapGrubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\NesneGrubu
     */
    public $HesapGrubu;
    /**
     * The Grubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\HesapGrubu
     */
    public $Grubu;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * Constructor method for Hesap
     * @uses Hesap::setAciklama()
     * @uses Hesap::setAcanIsYeri()
     * @uses Hesap::setAcanBolum()
     * @uses Hesap::setHesapGrubu()
     * @uses Hesap::setGrubu()
     * @uses Hesap::setKodu()
     * @uses Hesap::setAdi()
     * @param string $aciklama
     * @param \fk_\StructType\IsYeriPointer $acanIsYeri
     * @param \fk_\StructType\BolumPointer $acanBolum
     * @param \fk_\StructType\NesneGrubu $hesapGrubu
     * @param \fk_\StructType\HesapGrubu $grubu
     * @param string $kodu
     * @param string $adi
     */
    public function __construct($aciklama = null, \fk_\StructType\IsYeriPointer $acanIsYeri = null, \fk_\StructType\BolumPointer $acanBolum = null, \fk_\StructType\NesneGrubu $hesapGrubu = null, \fk_\StructType\HesapGrubu $grubu = null, $kodu = null, $adi = null)
    {
        $this
            ->setAciklama($aciklama)
            ->setAcanIsYeri($acanIsYeri)
            ->setAcanBolum($acanBolum)
            ->setHesapGrubu($hesapGrubu)
            ->setGrubu($grubu)
            ->setKodu($kodu)
            ->setAdi($adi);
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\Hesap
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get AcanIsYeri value
     * @return \fk_\StructType\IsYeriPointer|null
     */
    public function getAcanIsYeri()
    {
        return $this->AcanIsYeri;
    }
    /**
     * Set AcanIsYeri value
     * @param \fk_\StructType\IsYeriPointer $acanIsYeri
     * @return \fk_\StructType\Hesap
     */
    public function setAcanIsYeri(\fk_\StructType\IsYeriPointer $acanIsYeri = null)
    {
        $this->AcanIsYeri = $acanIsYeri;
        return $this;
    }
    /**
     * Get AcanBolum value
     * @return \fk_\StructType\BolumPointer|null
     */
    public function getAcanBolum()
    {
        return $this->AcanBolum;
    }
    /**
     * Set AcanBolum value
     * @param \fk_\StructType\BolumPointer $acanBolum
     * @return \fk_\StructType\Hesap
     */
    public function setAcanBolum(\fk_\StructType\BolumPointer $acanBolum = null)
    {
        $this->AcanBolum = $acanBolum;
        return $this;
    }
    /**
     * Get HesapGrubu value
     * @return \fk_\StructType\NesneGrubu|null
     */
    public function getHesapGrubu()
    {
        return $this->HesapGrubu;
    }
    /**
     * Set HesapGrubu value
     * @param \fk_\StructType\NesneGrubu $hesapGrubu
     * @return \fk_\StructType\Hesap
     */
    public function setHesapGrubu(\fk_\StructType\NesneGrubu $hesapGrubu = null)
    {
        $this->HesapGrubu = $hesapGrubu;
        return $this;
    }
    /**
     * Get Grubu value
     * @return \fk_\StructType\HesapGrubu|null
     */
    public function getGrubu()
    {
        return $this->Grubu;
    }
    /**
     * Set Grubu value
     * @param \fk_\StructType\HesapGrubu $grubu
     * @return \fk_\StructType\Hesap
     */
    public function setGrubu(\fk_\StructType\HesapGrubu $grubu = null)
    {
        $this->Grubu = $grubu;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \fk_\StructType\Hesap
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\Hesap
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\Hesap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
