<?php

namespace fk_\EnumType;

/**
 * This class stands for KIslemPeriodu EnumType
 * @subpackage Enumerations
 */
class KIslemPeriodu
{
    /**
     * Constant for value 'Aylik'
     * @return string 'Aylik'
     */
    const VALUE_AYLIK = 'Aylik';
    /**
     * Constant for value 'Haftalik'
     * @return string 'Haftalik'
     */
    const VALUE_HAFTALIK = 'Haftalik';
    /**
     * Constant for value 'IkiHaftalik'
     * @return string 'IkiHaftalik'
     */
    const VALUE_IKI_HAFTALIK = 'IkiHaftalik';
    /**
     * Constant for value 'UcHaftalik'
     * @return string 'UcHaftalik'
     */
    const VALUE_UC_HAFTALIK = 'UcHaftalik';
    /**
     * Constant for value 'OnGunluk'
     * @return string 'OnGunluk'
     */
    const VALUE_ON_GUNLUK = 'OnGunluk';
    /**
     * Constant for value 'YirmiGunluk'
     * @return string 'YirmiGunluk'
     */
    const VALUE_YIRMI_GUNLUK = 'YirmiGunluk';
    /**
     * Constant for value 'Gunluk'
     * @return string 'Gunluk'
     */
    const VALUE_GUNLUK = 'Gunluk';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AYLIK
     * @uses self::VALUE_HAFTALIK
     * @uses self::VALUE_IKI_HAFTALIK
     * @uses self::VALUE_UC_HAFTALIK
     * @uses self::VALUE_ON_GUNLUK
     * @uses self::VALUE_YIRMI_GUNLUK
     * @uses self::VALUE_GUNLUK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AYLIK,
            self::VALUE_HAFTALIK,
            self::VALUE_IKI_HAFTALIK,
            self::VALUE_UC_HAFTALIK,
            self::VALUE_ON_GUNLUK,
            self::VALUE_YIRMI_GUNLUK,
            self::VALUE_GUNLUK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
