<?php

namespace fk_\EnumType;

/**
 * This class stands for BakiyeTipi EnumType
 * @subpackage Enumerations
 */
class BakiyeTipi
{
    /**
     * Constant for value 'Hicbiri'
     * @return string 'Hicbiri'
     */
    const VALUE_HICBIRI = 'Hicbiri';
    /**
     * Constant for value 'Borclu'
     * @return string 'Borclu'
     */
    const VALUE_BORCLU = 'Borclu';
    /**
     * Constant for value 'Alacakli'
     * @return string 'Alacakli'
     */
    const VALUE_ALACAKLI = 'Alacakli';
    /**
     * Constant for value 'Serbest'
     * @return string 'Serbest'
     */
    const VALUE_SERBEST = 'Serbest';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HICBIRI
     * @uses self::VALUE_BORCLU
     * @uses self::VALUE_ALACAKLI
     * @uses self::VALUE_SERBEST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HICBIRI,
            self::VALUE_BORCLU,
            self::VALUE_ALACAKLI,
            self::VALUE_SERBEST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
