<?php

namespace fk_\EnumType;

/**
 * This class stands for KimlikTip EnumType
 * @subpackage Enumerations
 */
class KimlikTip
{
    /**
     * Constant for value 'Ehliyet'
     * @return string 'Ehliyet'
     */
    const VALUE_EHLIYET = 'Ehliyet';
    /**
     * Constant for value 'NufusCuzdan'
     * @return string 'NufusCuzdan'
     */
    const VALUE_NUFUS_CUZDAN = 'NufusCuzdan';
    /**
     * Constant for value 'Pasaport'
     * @return string 'Pasaport'
     */
    const VALUE_PASAPORT = 'Pasaport';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_EHLIYET
     * @uses self::VALUE_NUFUS_CUZDAN
     * @uses self::VALUE_PASAPORT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EHLIYET,
            self::VALUE_NUFUS_CUZDAN,
            self::VALUE_PASAPORT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
