<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Entity StructType
 * @subpackage Structs
 */
abstract class Entity extends BaseEntity
{
    /**
     * The ObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ObjId;
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Aktif;
    /**
     * The IsOther
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IsOther;
    /**
     * The usedObjIdForInsert
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $usedObjIdForInsert;
    /**
     * The ValidasyonAsamasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidasyonAsamasi;
    /**
     * The KayitGirisSiniriKontroluUygula
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $KayitGirisSiniriKontroluUygula;
    /**
     * The Sirketi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\SirketPointer
     */
    public $Sirketi;
    /**
     * The Sistem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\SistemBilgileri
     */
    public $Sistem;
    /**
     * The ApprovalKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovalKey;
    /**
     * The NameForDeletion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameForDeletion;
    /**
     * The OldMuhasebeFisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $OldMuhasebeFisi;
    /**
     * The NewMuhasebeFisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $NewMuhasebeFisi;
    /**
     * Constructor method for Entity
     * @uses Entity::setObjId()
     * @uses Entity::setAktif()
     * @uses Entity::setIsOther()
     * @uses Entity::setUsedObjIdForInsert()
     * @uses Entity::setValidasyonAsamasi()
     * @uses Entity::setKayitGirisSiniriKontroluUygula()
     * @uses Entity::setSirketi()
     * @uses Entity::setSistem()
     * @uses Entity::setApprovalKey()
     * @uses Entity::setNameForDeletion()
     * @uses Entity::setOldMuhasebeFisi()
     * @uses Entity::setNewMuhasebeFisi()
     * @param int $objId
     * @param bool $aktif
     * @param string $isOther
     * @param bool $usedObjIdForInsert
     * @param string $validasyonAsamasi
     * @param bool $kayitGirisSiniriKontroluUygula
     * @param \fk_\StructType\SirketPointer $sirketi
     * @param \fk_\StructType\SistemBilgileri $sistem
     * @param string $approvalKey
     * @param string $nameForDeletion
     * @param mixed $oldMuhasebeFisi
     * @param mixed $newMuhasebeFisi
     */
    public function __construct($objId = null, $aktif = null, $isOther = null, $usedObjIdForInsert = null, $validasyonAsamasi = null, $kayitGirisSiniriKontroluUygula = null, \fk_\StructType\SirketPointer $sirketi = null, \fk_\StructType\SistemBilgileri $sistem = null, $approvalKey = null, $nameForDeletion = null, $oldMuhasebeFisi = null, $newMuhasebeFisi = null)
    {
        $this
            ->setObjId($objId)
            ->setAktif($aktif)
            ->setIsOther($isOther)
            ->setUsedObjIdForInsert($usedObjIdForInsert)
            ->setValidasyonAsamasi($validasyonAsamasi)
            ->setKayitGirisSiniriKontroluUygula($kayitGirisSiniriKontroluUygula)
            ->setSirketi($sirketi)
            ->setSistem($sistem)
            ->setApprovalKey($approvalKey)
            ->setNameForDeletion($nameForDeletion)
            ->setOldMuhasebeFisi($oldMuhasebeFisi)
            ->setNewMuhasebeFisi($newMuhasebeFisi);
    }
    /**
     * Get ObjId value
     * @return int
     */
    public function getObjId()
    {
        return $this->ObjId;
    }
    /**
     * Set ObjId value
     * @param int $objId
     * @return \fk_\StructType\Entity
     */
    public function setObjId($objId = null)
    {
        // validation for constraint: int
        if (!is_null($objId) && !(is_int($objId) || ctype_digit($objId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objId, true), gettype($objId)), __LINE__);
        }
        $this->ObjId = $objId;
        return $this;
    }
    /**
     * Get Aktif value
     * @return bool
     */
    public function getAktif()
    {
        return $this->Aktif;
    }
    /**
     * Set Aktif value
     * @param bool $aktif
     * @return \fk_\StructType\Entity
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: boolean
        if (!is_null($aktif) && !is_bool($aktif)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        $this->Aktif = $aktif;
        return $this;
    }
    /**
     * Get IsOther value
     * @return string
     */
    public function getIsOther()
    {
        return $this->IsOther;
    }
    /**
     * Set IsOther value
     * @param string $isOther
     * @return \fk_\StructType\Entity
     */
    public function setIsOther($isOther = null)
    {
        // validation for constraint: string
        if (!is_null($isOther) && !is_string($isOther)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isOther, true), gettype($isOther)), __LINE__);
        }
        $this->IsOther = $isOther;
        return $this;
    }
    /**
     * Get usedObjIdForInsert value
     * @return bool
     */
    public function getUsedObjIdForInsert()
    {
        return $this->usedObjIdForInsert;
    }
    /**
     * Set usedObjIdForInsert value
     * @param bool $usedObjIdForInsert
     * @return \fk_\StructType\Entity
     */
    public function setUsedObjIdForInsert($usedObjIdForInsert = null)
    {
        // validation for constraint: boolean
        if (!is_null($usedObjIdForInsert) && !is_bool($usedObjIdForInsert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usedObjIdForInsert, true), gettype($usedObjIdForInsert)), __LINE__);
        }
        $this->usedObjIdForInsert = $usedObjIdForInsert;
        return $this;
    }
    /**
     * Get ValidasyonAsamasi value
     * @return string
     */
    public function getValidasyonAsamasi()
    {
        return $this->ValidasyonAsamasi;
    }
    /**
     * Set ValidasyonAsamasi value
     * @uses \fk_\EnumType\OncekiAylaraKayitGirisSiniriValidasyonAsamalari::valueIsValid()
     * @uses \fk_\EnumType\OncekiAylaraKayitGirisSiniriValidasyonAsamalari::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $validasyonAsamasi
     * @return \fk_\StructType\Entity
     */
    public function setValidasyonAsamasi($validasyonAsamasi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\OncekiAylaraKayitGirisSiniriValidasyonAsamalari::valueIsValid($validasyonAsamasi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\OncekiAylaraKayitGirisSiniriValidasyonAsamalari', is_array($validasyonAsamasi) ? implode(', ', $validasyonAsamasi) : var_export($validasyonAsamasi, true), implode(', ', \fk_\EnumType\OncekiAylaraKayitGirisSiniriValidasyonAsamalari::getValidValues())), __LINE__);
        }
        $this->ValidasyonAsamasi = $validasyonAsamasi;
        return $this;
    }
    /**
     * Get KayitGirisSiniriKontroluUygula value
     * @return bool
     */
    public function getKayitGirisSiniriKontroluUygula()
    {
        return $this->KayitGirisSiniriKontroluUygula;
    }
    /**
     * Set KayitGirisSiniriKontroluUygula value
     * @param bool $kayitGirisSiniriKontroluUygula
     * @return \fk_\StructType\Entity
     */
    public function setKayitGirisSiniriKontroluUygula($kayitGirisSiniriKontroluUygula = null)
    {
        // validation for constraint: boolean
        if (!is_null($kayitGirisSiniriKontroluUygula) && !is_bool($kayitGirisSiniriKontroluUygula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kayitGirisSiniriKontroluUygula, true), gettype($kayitGirisSiniriKontroluUygula)), __LINE__);
        }
        $this->KayitGirisSiniriKontroluUygula = $kayitGirisSiniriKontroluUygula;
        return $this;
    }
    /**
     * Get Sirketi value
     * @return \fk_\StructType\SirketPointer|null
     */
    public function getSirketi()
    {
        return $this->Sirketi;
    }
    /**
     * Set Sirketi value
     * @param \fk_\StructType\SirketPointer $sirketi
     * @return \fk_\StructType\Entity
     */
    public function setSirketi(\fk_\StructType\SirketPointer $sirketi = null)
    {
        $this->Sirketi = $sirketi;
        return $this;
    }
    /**
     * Get Sistem value
     * @return \fk_\StructType\SistemBilgileri|null
     */
    public function getSistem()
    {
        return $this->Sistem;
    }
    /**
     * Set Sistem value
     * @param \fk_\StructType\SistemBilgileri $sistem
     * @return \fk_\StructType\Entity
     */
    public function setSistem(\fk_\StructType\SistemBilgileri $sistem = null)
    {
        $this->Sistem = $sistem;
        return $this;
    }
    /**
     * Get ApprovalKey value
     * @return string|null
     */
    public function getApprovalKey()
    {
        return $this->ApprovalKey;
    }
    /**
     * Set ApprovalKey value
     * @param string $approvalKey
     * @return \fk_\StructType\Entity
     */
    public function setApprovalKey($approvalKey = null)
    {
        // validation for constraint: string
        if (!is_null($approvalKey) && !is_string($approvalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalKey, true), gettype($approvalKey)), __LINE__);
        }
        $this->ApprovalKey = $approvalKey;
        return $this;
    }
    /**
     * Get NameForDeletion value
     * @return string|null
     */
    public function getNameForDeletion()
    {
        return $this->NameForDeletion;
    }
    /**
     * Set NameForDeletion value
     * @param string $nameForDeletion
     * @return \fk_\StructType\Entity
     */
    public function setNameForDeletion($nameForDeletion = null)
    {
        // validation for constraint: string
        if (!is_null($nameForDeletion) && !is_string($nameForDeletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameForDeletion, true), gettype($nameForDeletion)), __LINE__);
        }
        $this->NameForDeletion = $nameForDeletion;
        return $this;
    }
    /**
     * Get OldMuhasebeFisi value
     * @return mixed|null
     */
    public function getOldMuhasebeFisi()
    {
        return $this->OldMuhasebeFisi;
    }
    /**
     * Set OldMuhasebeFisi value
     * @param mixed $oldMuhasebeFisi
     * @return \fk_\StructType\Entity
     */
    public function setOldMuhasebeFisi($oldMuhasebeFisi = null)
    {
        $this->OldMuhasebeFisi = $oldMuhasebeFisi;
        return $this;
    }
    /**
     * Get NewMuhasebeFisi value
     * @return mixed|null
     */
    public function getNewMuhasebeFisi()
    {
        return $this->NewMuhasebeFisi;
    }
    /**
     * Set NewMuhasebeFisi value
     * @param mixed $newMuhasebeFisi
     * @return \fk_\StructType\Entity
     */
    public function setNewMuhasebeFisi($newMuhasebeFisi = null)
    {
        $this->NewMuhasebeFisi = $newMuhasebeFisi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\Entity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
