<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracTuru EnumType
 * @subpackage Enumerations
 */
class KAracTuru
{
    /**
     * Constant for value 'KaraYoluAraci'
     * @return string 'KaraYoluAraci'
     */
    const VALUE_KARA_YOLU_ARACI = 'KaraYoluAraci';
    /**
     * Constant for value 'Ucak'
     * @return string 'Ucak'
     */
    const VALUE_UCAK = 'Ucak';
    /**
     * Constant for value 'MotorKurye'
     * @return string 'MotorKurye'
     */
    const VALUE_MOTOR_KURYE = 'MotorKurye';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_KARA_YOLU_ARACI
     * @uses self::VALUE_UCAK
     * @uses self::VALUE_MOTOR_KURYE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_KARA_YOLU_ARACI,
            self::VALUE_UCAK,
            self::VALUE_MOTOR_KURYE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
