<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeriZimmet StructType
 * @subpackage Structs
 */
abstract class SeriZimmet extends Entity
{
    /**
     * The BaslangicSira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BaslangicSira;
    /**
     * The BitisSira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BitisSira;
    /**
     * The SonKullanilanSira
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SonKullanilanSira;
    /**
     * The ZimmetDurumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ZimmetDurumu;
    /**
     * The Kaynak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Kaynak;
    /**
     * The Seri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Seri;
    /**
     * Constructor method for SeriZimmet
     * @uses SeriZimmet::setBaslangicSira()
     * @uses SeriZimmet::setBitisSira()
     * @uses SeriZimmet::setSonKullanilanSira()
     * @uses SeriZimmet::setZimmetDurumu()
     * @uses SeriZimmet::setKaynak()
     * @uses SeriZimmet::setSeri()
     * @param float $baslangicSira
     * @param float $bitisSira
     * @param float $sonKullanilanSira
     * @param string $zimmetDurumu
     * @param string $kaynak
     * @param string $seri
     */
    public function __construct($baslangicSira = null, $bitisSira = null, $sonKullanilanSira = null, $zimmetDurumu = null, $kaynak = null, $seri = null)
    {
        $this
            ->setBaslangicSira($baslangicSira)
            ->setBitisSira($bitisSira)
            ->setSonKullanilanSira($sonKullanilanSira)
            ->setZimmetDurumu($zimmetDurumu)
            ->setKaynak($kaynak)
            ->setSeri($seri);
    }
    /**
     * Get BaslangicSira value
     * @return float
     */
    public function getBaslangicSira()
    {
        return $this->BaslangicSira;
    }
    /**
     * Set BaslangicSira value
     * @param float $baslangicSira
     * @return \fk_\StructType\SeriZimmet
     */
    public function setBaslangicSira($baslangicSira = null)
    {
        // validation for constraint: float
        if (!is_null($baslangicSira) && !(is_float($baslangicSira) || is_numeric($baslangicSira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baslangicSira, true), gettype($baslangicSira)), __LINE__);
        }
        $this->BaslangicSira = $baslangicSira;
        return $this;
    }
    /**
     * Get BitisSira value
     * @return float
     */
    public function getBitisSira()
    {
        return $this->BitisSira;
    }
    /**
     * Set BitisSira value
     * @param float $bitisSira
     * @return \fk_\StructType\SeriZimmet
     */
    public function setBitisSira($bitisSira = null)
    {
        // validation for constraint: float
        if (!is_null($bitisSira) && !(is_float($bitisSira) || is_numeric($bitisSira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bitisSira, true), gettype($bitisSira)), __LINE__);
        }
        $this->BitisSira = $bitisSira;
        return $this;
    }
    /**
     * Get SonKullanilanSira value
     * @return float
     */
    public function getSonKullanilanSira()
    {
        return $this->SonKullanilanSira;
    }
    /**
     * Set SonKullanilanSira value
     * @param float $sonKullanilanSira
     * @return \fk_\StructType\SeriZimmet
     */
    public function setSonKullanilanSira($sonKullanilanSira = null)
    {
        // validation for constraint: float
        if (!is_null($sonKullanilanSira) && !(is_float($sonKullanilanSira) || is_numeric($sonKullanilanSira))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sonKullanilanSira, true), gettype($sonKullanilanSira)), __LINE__);
        }
        $this->SonKullanilanSira = $sonKullanilanSira;
        return $this;
    }
    /**
     * Get ZimmetDurumu value
     * @return string
     */
    public function getZimmetDurumu()
    {
        return $this->ZimmetDurumu;
    }
    /**
     * Set ZimmetDurumu value
     * @uses \fk_\EnumType\ZimmetDurum::valueIsValid()
     * @uses \fk_\EnumType\ZimmetDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zimmetDurumu
     * @return \fk_\StructType\SeriZimmet
     */
    public function setZimmetDurumu($zimmetDurumu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\ZimmetDurum::valueIsValid($zimmetDurumu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\ZimmetDurum', is_array($zimmetDurumu) ? implode(', ', $zimmetDurumu) : var_export($zimmetDurumu, true), implode(', ', \fk_\EnumType\ZimmetDurum::getValidValues())), __LINE__);
        }
        $this->ZimmetDurumu = $zimmetDurumu;
        return $this;
    }
    /**
     * Get Kaynak value
     * @return string
     */
    public function getKaynak()
    {
        return $this->Kaynak;
    }
    /**
     * Set Kaynak value
     * @uses \fk_\EnumType\ZimmetTuru::valueIsValid()
     * @uses \fk_\EnumType\ZimmetTuru::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kaynak
     * @return \fk_\StructType\SeriZimmet
     */
    public function setKaynak($kaynak = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\ZimmetTuru::valueIsValid($kaynak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\ZimmetTuru', is_array($kaynak) ? implode(', ', $kaynak) : var_export($kaynak, true), implode(', ', \fk_\EnumType\ZimmetTuru::getValidValues())), __LINE__);
        }
        $this->Kaynak = $kaynak;
        return $this;
    }
    /**
     * Get Seri value
     * @return string|null
     */
    public function getSeri()
    {
        return $this->Seri;
    }
    /**
     * Set Seri value
     * @param string $seri
     * @return \fk_\StructType\SeriZimmet
     */
    public function setSeri($seri = null)
    {
        // validation for constraint: string
        if (!is_null($seri) && !is_string($seri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seri, true), gettype($seri)), __LINE__);
        }
        $this->Seri = $seri;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\SeriZimmet
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
