<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HesapGrubuTanimi StructType
 * @subpackage Structs
 */
class HesapGrubuTanimi extends SerendipEntity
{
    /**
     * The SiraNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SiraNo;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The UstGrup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\HesapGrubuTanimiPointer
     */
    public $UstGrup;
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\HesapTuruPointer
     */
    public $Turu;
    /**
     * The KisaKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KisaKodu;
    /**
     * Constructor method for HesapGrubuTanimi
     * @uses HesapGrubuTanimi::setSiraNo()
     * @uses HesapGrubuTanimi::setAdi()
     * @uses HesapGrubuTanimi::setUstGrup()
     * @uses HesapGrubuTanimi::setTuru()
     * @uses HesapGrubuTanimi::setKisaKodu()
     * @param int $siraNo
     * @param string $adi
     * @param \fk_\StructType\HesapGrubuTanimiPointer $ustGrup
     * @param \fk_\StructType\HesapTuruPointer $turu
     * @param string $kisaKodu
     */
    public function __construct($siraNo = null, $adi = null, \fk_\StructType\HesapGrubuTanimiPointer $ustGrup = null, \fk_\StructType\HesapTuruPointer $turu = null, $kisaKodu = null)
    {
        $this
            ->setSiraNo($siraNo)
            ->setAdi($adi)
            ->setUstGrup($ustGrup)
            ->setTuru($turu)
            ->setKisaKodu($kisaKodu);
    }
    /**
     * Get SiraNo value
     * @return int
     */
    public function getSiraNo()
    {
        return $this->SiraNo;
    }
    /**
     * Set SiraNo value
     * @param int $siraNo
     * @return \fk_\StructType\HesapGrubuTanimi
     */
    public function setSiraNo($siraNo = null)
    {
        // validation for constraint: int
        if (!is_null($siraNo) && !(is_int($siraNo) || ctype_digit($siraNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($siraNo, true), gettype($siraNo)), __LINE__);
        }
        $this->SiraNo = $siraNo;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\HesapGrubuTanimi
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get UstGrup value
     * @return \fk_\StructType\HesapGrubuTanimiPointer|null
     */
    public function getUstGrup()
    {
        return $this->UstGrup;
    }
    /**
     * Set UstGrup value
     * @param \fk_\StructType\HesapGrubuTanimiPointer $ustGrup
     * @return \fk_\StructType\HesapGrubuTanimi
     */
    public function setUstGrup(\fk_\StructType\HesapGrubuTanimiPointer $ustGrup = null)
    {
        $this->UstGrup = $ustGrup;
        return $this;
    }
    /**
     * Get Turu value
     * @return \fk_\StructType\HesapTuruPointer|null
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @param \fk_\StructType\HesapTuruPointer $turu
     * @return \fk_\StructType\HesapGrubuTanimi
     */
    public function setTuru(\fk_\StructType\HesapTuruPointer $turu = null)
    {
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get KisaKodu value
     * @return string|null
     */
    public function getKisaKodu()
    {
        return $this->KisaKodu;
    }
    /**
     * Set KisaKodu value
     * @param string $kisaKodu
     * @return \fk_\StructType\HesapGrubuTanimi
     */
    public function setKisaKodu($kisaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($kisaKodu) && !is_string($kisaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kisaKodu, true), gettype($kisaKodu)), __LINE__);
        }
        $this->KisaKodu = $kisaKodu;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\HesapGrubuTanimi
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
