<?php

namespace fk_\EnumType;

/**
 * This class stands for HatPeriyot EnumType
 * @subpackage Enumerations
 */
class HatPeriyot
{
    /**
     * Constant for value 'Gunluk'
     * @return string 'Gunluk'
     */
    const VALUE_GUNLUK = 'Gunluk';
    /**
     * Constant for value 'OnbesGunluk'
     * @return string 'OnbesGunluk'
     */
    const VALUE_ONBES_GUNLUK = 'OnbesGunluk';
    /**
     * Constant for value 'Aylik'
     * @return string 'Aylik'
     */
    const VALUE_AYLIK = 'Aylik';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GUNLUK
     * @uses self::VALUE_ONBES_GUNLUK
     * @uses self::VALUE_AYLIK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GUNLUK,
            self::VALUE_ONBES_GUNLUK,
            self::VALUE_AYLIK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
