<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CariFisiSatiri StructType
 * @subpackage Structs
 */
class CariFisiSatiri extends SerendipEntity
{
    /**
     * The KdvOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KdvOrani;
    /**
     * The KDVDahilMi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $KDVDahilMi;
    /**
     * The IlgiliOdemeTalepFormuSatirObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IlgiliOdemeTalepFormuSatirObjId;
    /**
     * The Cari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\CariHesabiPointer
     */
    public $Cari;
    /**
     * The KarsiCari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\CariHesabiPointer
     */
    public $KarsiCari;
    /**
     * The KarsiKasa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KasaHesabiPointer
     */
    public $KarsiKasa;
    /**
     * The Borc
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $Borc;
    /**
     * The Alacak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $Alacak;
    /**
     * The AlacakSatirPlani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\OdemePlaniPointer
     */
    public $AlacakSatirPlani;
    /**
     * The SatirPlani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\OdemePlaniPointer
     */
    public $SatirPlani;
    /**
     * The SatirGrubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\NesneGrubu
     */
    public $SatirGrubu;
    /**
     * The MakbuzNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MakbuzNo;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The KurFarkiDovizi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizTuruPointer
     */
    public $KurFarkiDovizi;
    /**
     * The KdvTutari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $KdvTutari;
    /**
     * The Islem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\EvrakIslemTuruPointer
     */
    public $Islem;
    /**
     * The CariFisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\CariFisiPointer
     */
    public $CariFisi;
    /**
     * The BorcIsyeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\IsYeriPointer
     */
    public $BorcIsyeri;
    /**
     * The AlacakIsyeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\IsYeriPointer
     */
    public $AlacakIsyeri;
    /**
     * The IlgiliProje
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\PYProjePointer
     */
    public $IlgiliProje;
    /**
     * The SatisFaturasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\SatisFaturasiPointer
     */
    public $SatisFaturasi;
    /**
     * The IlgiliAlimEvraklari
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\ArrayType\ArrayOfCariFisiIlgiliAlimEvragi
     */
    public $IlgiliAlimEvraklari;
    /**
     * The OdemeTalepFormundaKullanilanTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $OdemeTalepFormundaKullanilanTutar;
    /**
     * Constructor method for CariFisiSatiri
     * @uses CariFisiSatiri::setKdvOrani()
     * @uses CariFisiSatiri::setKDVDahilMi()
     * @uses CariFisiSatiri::setIlgiliOdemeTalepFormuSatirObjId()
     * @uses CariFisiSatiri::setCari()
     * @uses CariFisiSatiri::setKarsiCari()
     * @uses CariFisiSatiri::setKarsiKasa()
     * @uses CariFisiSatiri::setBorc()
     * @uses CariFisiSatiri::setAlacak()
     * @uses CariFisiSatiri::setAlacakSatirPlani()
     * @uses CariFisiSatiri::setSatirPlani()
     * @uses CariFisiSatiri::setSatirGrubu()
     * @uses CariFisiSatiri::setMakbuzNo()
     * @uses CariFisiSatiri::setAciklama()
     * @uses CariFisiSatiri::setKurFarkiDovizi()
     * @uses CariFisiSatiri::setKdvTutari()
     * @uses CariFisiSatiri::setIslem()
     * @uses CariFisiSatiri::setCariFisi()
     * @uses CariFisiSatiri::setBorcIsyeri()
     * @uses CariFisiSatiri::setAlacakIsyeri()
     * @uses CariFisiSatiri::setIlgiliProje()
     * @uses CariFisiSatiri::setSatisFaturasi()
     * @uses CariFisiSatiri::setIlgiliAlimEvraklari()
     * @uses CariFisiSatiri::setOdemeTalepFormundaKullanilanTutar()
     * @param float $kdvOrani
     * @param bool $kDVDahilMi
     * @param int $ilgiliOdemeTalepFormuSatirObjId
     * @param \fk_\StructType\CariHesabiPointer $cari
     * @param \fk_\StructType\CariHesabiPointer $karsiCari
     * @param \fk_\StructType\KasaHesabiPointer $karsiKasa
     * @param \fk_\StructType\DovizliTutar $borc
     * @param \fk_\StructType\DovizliTutar $alacak
     * @param \fk_\StructType\OdemePlaniPointer $alacakSatirPlani
     * @param \fk_\StructType\OdemePlaniPointer $satirPlani
     * @param \fk_\StructType\NesneGrubu $satirGrubu
     * @param string $makbuzNo
     * @param string $aciklama
     * @param \fk_\StructType\DovizTuruPointer $kurFarkiDovizi
     * @param \fk_\StructType\DovizliTutar $kdvTutari
     * @param \fk_\StructType\EvrakIslemTuruPointer $islem
     * @param \fk_\StructType\CariFisiPointer $cariFisi
     * @param \fk_\StructType\IsYeriPointer $borcIsyeri
     * @param \fk_\StructType\IsYeriPointer $alacakIsyeri
     * @param \fk_\StructType\PYProjePointer $ilgiliProje
     * @param \fk_\StructType\SatisFaturasiPointer $satisFaturasi
     * @param \fk_\ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari
     * @param \fk_\StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar
     */
    public function __construct($kdvOrani = null, $kDVDahilMi = null, $ilgiliOdemeTalepFormuSatirObjId = null, \fk_\StructType\CariHesabiPointer $cari = null, \fk_\StructType\CariHesabiPointer $karsiCari = null, \fk_\StructType\KasaHesabiPointer $karsiKasa = null, \fk_\StructType\DovizliTutar $borc = null, \fk_\StructType\DovizliTutar $alacak = null, \fk_\StructType\OdemePlaniPointer $alacakSatirPlani = null, \fk_\StructType\OdemePlaniPointer $satirPlani = null, \fk_\StructType\NesneGrubu $satirGrubu = null, $makbuzNo = null, $aciklama = null, \fk_\StructType\DovizTuruPointer $kurFarkiDovizi = null, \fk_\StructType\DovizliTutar $kdvTutari = null, \fk_\StructType\EvrakIslemTuruPointer $islem = null, \fk_\StructType\CariFisiPointer $cariFisi = null, \fk_\StructType\IsYeriPointer $borcIsyeri = null, \fk_\StructType\IsYeriPointer $alacakIsyeri = null, \fk_\StructType\PYProjePointer $ilgiliProje = null, \fk_\StructType\SatisFaturasiPointer $satisFaturasi = null, \fk_\ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari = null, \fk_\StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar = null)
    {
        $this
            ->setKdvOrani($kdvOrani)
            ->setKDVDahilMi($kDVDahilMi)
            ->setIlgiliOdemeTalepFormuSatirObjId($ilgiliOdemeTalepFormuSatirObjId)
            ->setCari($cari)
            ->setKarsiCari($karsiCari)
            ->setKarsiKasa($karsiKasa)
            ->setBorc($borc)
            ->setAlacak($alacak)
            ->setAlacakSatirPlani($alacakSatirPlani)
            ->setSatirPlani($satirPlani)
            ->setSatirGrubu($satirGrubu)
            ->setMakbuzNo($makbuzNo)
            ->setAciklama($aciklama)
            ->setKurFarkiDovizi($kurFarkiDovizi)
            ->setKdvTutari($kdvTutari)
            ->setIslem($islem)
            ->setCariFisi($cariFisi)
            ->setBorcIsyeri($borcIsyeri)
            ->setAlacakIsyeri($alacakIsyeri)
            ->setIlgiliProje($ilgiliProje)
            ->setSatisFaturasi($satisFaturasi)
            ->setIlgiliAlimEvraklari($ilgiliAlimEvraklari)
            ->setOdemeTalepFormundaKullanilanTutar($odemeTalepFormundaKullanilanTutar);
    }
    /**
     * Get KdvOrani value
     * @return float
     */
    public function getKdvOrani()
    {
        return $this->KdvOrani;
    }
    /**
     * Set KdvOrani value
     * @param float $kdvOrani
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setKdvOrani($kdvOrani = null)
    {
        // validation for constraint: float
        if (!is_null($kdvOrani) && !(is_float($kdvOrani) || is_numeric($kdvOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kdvOrani, true), gettype($kdvOrani)), __LINE__);
        }
        $this->KdvOrani = $kdvOrani;
        return $this;
    }
    /**
     * Get KDVDahilMi value
     * @return bool
     */
    public function getKDVDahilMi()
    {
        return $this->KDVDahilMi;
    }
    /**
     * Set KDVDahilMi value
     * @param bool $kDVDahilMi
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setKDVDahilMi($kDVDahilMi = null)
    {
        // validation for constraint: boolean
        if (!is_null($kDVDahilMi) && !is_bool($kDVDahilMi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kDVDahilMi, true), gettype($kDVDahilMi)), __LINE__);
        }
        $this->KDVDahilMi = $kDVDahilMi;
        return $this;
    }
    /**
     * Get IlgiliOdemeTalepFormuSatirObjId value
     * @return int
     */
    public function getIlgiliOdemeTalepFormuSatirObjId()
    {
        return $this->IlgiliOdemeTalepFormuSatirObjId;
    }
    /**
     * Set IlgiliOdemeTalepFormuSatirObjId value
     * @param int $ilgiliOdemeTalepFormuSatirObjId
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setIlgiliOdemeTalepFormuSatirObjId($ilgiliOdemeTalepFormuSatirObjId = null)
    {
        // validation for constraint: int
        if (!is_null($ilgiliOdemeTalepFormuSatirObjId) && !(is_int($ilgiliOdemeTalepFormuSatirObjId) || ctype_digit($ilgiliOdemeTalepFormuSatirObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ilgiliOdemeTalepFormuSatirObjId, true), gettype($ilgiliOdemeTalepFormuSatirObjId)), __LINE__);
        }
        $this->IlgiliOdemeTalepFormuSatirObjId = $ilgiliOdemeTalepFormuSatirObjId;
        return $this;
    }
    /**
     * Get Cari value
     * @return \fk_\StructType\CariHesabiPointer|null
     */
    public function getCari()
    {
        return $this->Cari;
    }
    /**
     * Set Cari value
     * @param \fk_\StructType\CariHesabiPointer $cari
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setCari(\fk_\StructType\CariHesabiPointer $cari = null)
    {
        $this->Cari = $cari;
        return $this;
    }
    /**
     * Get KarsiCari value
     * @return \fk_\StructType\CariHesabiPointer|null
     */
    public function getKarsiCari()
    {
        return $this->KarsiCari;
    }
    /**
     * Set KarsiCari value
     * @param \fk_\StructType\CariHesabiPointer $karsiCari
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setKarsiCari(\fk_\StructType\CariHesabiPointer $karsiCari = null)
    {
        $this->KarsiCari = $karsiCari;
        return $this;
    }
    /**
     * Get KarsiKasa value
     * @return \fk_\StructType\KasaHesabiPointer|null
     */
    public function getKarsiKasa()
    {
        return $this->KarsiKasa;
    }
    /**
     * Set KarsiKasa value
     * @param \fk_\StructType\KasaHesabiPointer $karsiKasa
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setKarsiKasa(\fk_\StructType\KasaHesabiPointer $karsiKasa = null)
    {
        $this->KarsiKasa = $karsiKasa;
        return $this;
    }
    /**
     * Get Borc value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getBorc()
    {
        return $this->Borc;
    }
    /**
     * Set Borc value
     * @param \fk_\StructType\DovizliTutar $borc
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setBorc(\fk_\StructType\DovizliTutar $borc = null)
    {
        $this->Borc = $borc;
        return $this;
    }
    /**
     * Get Alacak value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getAlacak()
    {
        return $this->Alacak;
    }
    /**
     * Set Alacak value
     * @param \fk_\StructType\DovizliTutar $alacak
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setAlacak(\fk_\StructType\DovizliTutar $alacak = null)
    {
        $this->Alacak = $alacak;
        return $this;
    }
    /**
     * Get AlacakSatirPlani value
     * @return \fk_\StructType\OdemePlaniPointer|null
     */
    public function getAlacakSatirPlani()
    {
        return $this->AlacakSatirPlani;
    }
    /**
     * Set AlacakSatirPlani value
     * @param \fk_\StructType\OdemePlaniPointer $alacakSatirPlani
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setAlacakSatirPlani(\fk_\StructType\OdemePlaniPointer $alacakSatirPlani = null)
    {
        $this->AlacakSatirPlani = $alacakSatirPlani;
        return $this;
    }
    /**
     * Get SatirPlani value
     * @return \fk_\StructType\OdemePlaniPointer|null
     */
    public function getSatirPlani()
    {
        return $this->SatirPlani;
    }
    /**
     * Set SatirPlani value
     * @param \fk_\StructType\OdemePlaniPointer $satirPlani
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setSatirPlani(\fk_\StructType\OdemePlaniPointer $satirPlani = null)
    {
        $this->SatirPlani = $satirPlani;
        return $this;
    }
    /**
     * Get SatirGrubu value
     * @return \fk_\StructType\NesneGrubu|null
     */
    public function getSatirGrubu()
    {
        return $this->SatirGrubu;
    }
    /**
     * Set SatirGrubu value
     * @param \fk_\StructType\NesneGrubu $satirGrubu
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setSatirGrubu(\fk_\StructType\NesneGrubu $satirGrubu = null)
    {
        $this->SatirGrubu = $satirGrubu;
        return $this;
    }
    /**
     * Get MakbuzNo value
     * @return string|null
     */
    public function getMakbuzNo()
    {
        return $this->MakbuzNo;
    }
    /**
     * Set MakbuzNo value
     * @param string $makbuzNo
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setMakbuzNo($makbuzNo = null)
    {
        // validation for constraint: string
        if (!is_null($makbuzNo) && !is_string($makbuzNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($makbuzNo, true), gettype($makbuzNo)), __LINE__);
        }
        $this->MakbuzNo = $makbuzNo;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get KurFarkiDovizi value
     * @return \fk_\StructType\DovizTuruPointer|null
     */
    public function getKurFarkiDovizi()
    {
        return $this->KurFarkiDovizi;
    }
    /**
     * Set KurFarkiDovizi value
     * @param \fk_\StructType\DovizTuruPointer $kurFarkiDovizi
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setKurFarkiDovizi(\fk_\StructType\DovizTuruPointer $kurFarkiDovizi = null)
    {
        $this->KurFarkiDovizi = $kurFarkiDovizi;
        return $this;
    }
    /**
     * Get KdvTutari value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getKdvTutari()
    {
        return $this->KdvTutari;
    }
    /**
     * Set KdvTutari value
     * @param \fk_\StructType\DovizliTutar $kdvTutari
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setKdvTutari(\fk_\StructType\DovizliTutar $kdvTutari = null)
    {
        $this->KdvTutari = $kdvTutari;
        return $this;
    }
    /**
     * Get Islem value
     * @return \fk_\StructType\EvrakIslemTuruPointer|null
     */
    public function getIslem()
    {
        return $this->Islem;
    }
    /**
     * Set Islem value
     * @param \fk_\StructType\EvrakIslemTuruPointer $islem
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setIslem(\fk_\StructType\EvrakIslemTuruPointer $islem = null)
    {
        $this->Islem = $islem;
        return $this;
    }
    /**
     * Get CariFisi value
     * @return \fk_\StructType\CariFisiPointer|null
     */
    public function getCariFisi()
    {
        return $this->CariFisi;
    }
    /**
     * Set CariFisi value
     * @param \fk_\StructType\CariFisiPointer $cariFisi
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setCariFisi(\fk_\StructType\CariFisiPointer $cariFisi = null)
    {
        $this->CariFisi = $cariFisi;
        return $this;
    }
    /**
     * Get BorcIsyeri value
     * @return \fk_\StructType\IsYeriPointer|null
     */
    public function getBorcIsyeri()
    {
        return $this->BorcIsyeri;
    }
    /**
     * Set BorcIsyeri value
     * @param \fk_\StructType\IsYeriPointer $borcIsyeri
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setBorcIsyeri(\fk_\StructType\IsYeriPointer $borcIsyeri = null)
    {
        $this->BorcIsyeri = $borcIsyeri;
        return $this;
    }
    /**
     * Get AlacakIsyeri value
     * @return \fk_\StructType\IsYeriPointer|null
     */
    public function getAlacakIsyeri()
    {
        return $this->AlacakIsyeri;
    }
    /**
     * Set AlacakIsyeri value
     * @param \fk_\StructType\IsYeriPointer $alacakIsyeri
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setAlacakIsyeri(\fk_\StructType\IsYeriPointer $alacakIsyeri = null)
    {
        $this->AlacakIsyeri = $alacakIsyeri;
        return $this;
    }
    /**
     * Get IlgiliProje value
     * @return \fk_\StructType\PYProjePointer|null
     */
    public function getIlgiliProje()
    {
        return $this->IlgiliProje;
    }
    /**
     * Set IlgiliProje value
     * @param \fk_\StructType\PYProjePointer $ilgiliProje
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setIlgiliProje(\fk_\StructType\PYProjePointer $ilgiliProje = null)
    {
        $this->IlgiliProje = $ilgiliProje;
        return $this;
    }
    /**
     * Get SatisFaturasi value
     * @return \fk_\StructType\SatisFaturasiPointer|null
     */
    public function getSatisFaturasi()
    {
        return $this->SatisFaturasi;
    }
    /**
     * Set SatisFaturasi value
     * @param \fk_\StructType\SatisFaturasiPointer $satisFaturasi
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setSatisFaturasi(\fk_\StructType\SatisFaturasiPointer $satisFaturasi = null)
    {
        $this->SatisFaturasi = $satisFaturasi;
        return $this;
    }
    /**
     * Get IlgiliAlimEvraklari value
     * @return \fk_\ArrayType\ArrayOfCariFisiIlgiliAlimEvragi|null
     */
    public function getIlgiliAlimEvraklari()
    {
        return $this->IlgiliAlimEvraklari;
    }
    /**
     * Set IlgiliAlimEvraklari value
     * @param \fk_\ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setIlgiliAlimEvraklari(\fk_\ArrayType\ArrayOfCariFisiIlgiliAlimEvragi $ilgiliAlimEvraklari = null)
    {
        $this->IlgiliAlimEvraklari = $ilgiliAlimEvraklari;
        return $this;
    }
    /**
     * Get OdemeTalepFormundaKullanilanTutar value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getOdemeTalepFormundaKullanilanTutar()
    {
        return $this->OdemeTalepFormundaKullanilanTutar;
    }
    /**
     * Set OdemeTalepFormundaKullanilanTutar value
     * @param \fk_\StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar
     * @return \fk_\StructType\CariFisiSatiri
     */
    public function setOdemeTalepFormundaKullanilanTutar(\fk_\StructType\DovizliTutar $odemeTalepFormundaKullanilanTutar = null)
    {
        $this->OdemeTalepFormundaKullanilanTutar = $odemeTalepFormundaKullanilanTutar;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\CariFisiSatiri
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
