<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EvrakBase StructType
 * @subpackage Structs
 */
abstract class EvrakBase extends SerendipEvrakBase
{
    /**
     * The EvrakNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakNo;
    /**
     * The Turu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\EvrakTuruPointer
     */
    public $Turu;
    /**
     * The EvrakBolumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\BolumPointer
     */
    public $EvrakBolumu;
    /**
     * The EvrakIsYeri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\IsYeriPointer
     */
    public $EvrakIsYeri;
    /**
     * The EvrakGrubu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\NesneGrubu
     */
    public $EvrakGrubu;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * Constructor method for EvrakBase
     * @uses EvrakBase::setEvrakNo()
     * @uses EvrakBase::setTuru()
     * @uses EvrakBase::setEvrakBolumu()
     * @uses EvrakBase::setEvrakIsYeri()
     * @uses EvrakBase::setEvrakGrubu()
     * @uses EvrakBase::setAciklama()
     * @param string $evrakNo
     * @param \fk_\StructType\EvrakTuruPointer $turu
     * @param \fk_\StructType\BolumPointer $evrakBolumu
     * @param \fk_\StructType\IsYeriPointer $evrakIsYeri
     * @param \fk_\StructType\NesneGrubu $evrakGrubu
     * @param string $aciklama
     */
    public function __construct($evrakNo = null, \fk_\StructType\EvrakTuruPointer $turu = null, \fk_\StructType\BolumPointer $evrakBolumu = null, \fk_\StructType\IsYeriPointer $evrakIsYeri = null, \fk_\StructType\NesneGrubu $evrakGrubu = null, $aciklama = null)
    {
        $this
            ->setEvrakNo($evrakNo)
            ->setTuru($turu)
            ->setEvrakBolumu($evrakBolumu)
            ->setEvrakIsYeri($evrakIsYeri)
            ->setEvrakGrubu($evrakGrubu)
            ->setAciklama($aciklama);
    }
    /**
     * Get EvrakNo value
     * @return string|null
     */
    public function getEvrakNo()
    {
        return $this->EvrakNo;
    }
    /**
     * Set EvrakNo value
     * @param string $evrakNo
     * @return \fk_\StructType\EvrakBase
     */
    public function setEvrakNo($evrakNo = null)
    {
        // validation for constraint: string
        if (!is_null($evrakNo) && !is_string($evrakNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakNo, true), gettype($evrakNo)), __LINE__);
        }
        $this->EvrakNo = $evrakNo;
        return $this;
    }
    /**
     * Get Turu value
     * @return \fk_\StructType\EvrakTuruPointer|null
     */
    public function getTuru()
    {
        return $this->Turu;
    }
    /**
     * Set Turu value
     * @param \fk_\StructType\EvrakTuruPointer $turu
     * @return \fk_\StructType\EvrakBase
     */
    public function setTuru(\fk_\StructType\EvrakTuruPointer $turu = null)
    {
        $this->Turu = $turu;
        return $this;
    }
    /**
     * Get EvrakBolumu value
     * @return \fk_\StructType\BolumPointer|null
     */
    public function getEvrakBolumu()
    {
        return $this->EvrakBolumu;
    }
    /**
     * Set EvrakBolumu value
     * @param \fk_\StructType\BolumPointer $evrakBolumu
     * @return \fk_\StructType\EvrakBase
     */
    public function setEvrakBolumu(\fk_\StructType\BolumPointer $evrakBolumu = null)
    {
        $this->EvrakBolumu = $evrakBolumu;
        return $this;
    }
    /**
     * Get EvrakIsYeri value
     * @return \fk_\StructType\IsYeriPointer|null
     */
    public function getEvrakIsYeri()
    {
        return $this->EvrakIsYeri;
    }
    /**
     * Set EvrakIsYeri value
     * @param \fk_\StructType\IsYeriPointer $evrakIsYeri
     * @return \fk_\StructType\EvrakBase
     */
    public function setEvrakIsYeri(\fk_\StructType\IsYeriPointer $evrakIsYeri = null)
    {
        $this->EvrakIsYeri = $evrakIsYeri;
        return $this;
    }
    /**
     * Get EvrakGrubu value
     * @return \fk_\StructType\NesneGrubu|null
     */
    public function getEvrakGrubu()
    {
        return $this->EvrakGrubu;
    }
    /**
     * Set EvrakGrubu value
     * @param \fk_\StructType\NesneGrubu $evrakGrubu
     * @return \fk_\StructType\EvrakBase
     */
    public function setEvrakGrubu(\fk_\StructType\NesneGrubu $evrakGrubu = null)
    {
        $this->EvrakGrubu = $evrakGrubu;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\EvrakBase
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\EvrakBase
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
