<?php

namespace fk_\EnumType;

/**
 * This class stands for KontrolSekilleri EnumType
 * @subpackage Enumerations
 */
class KontrolSekilleri
{
    /**
     * Constant for value 'IslemeDevamEt'
     * @return string 'IslemeDevamEt'
     */
    const VALUE_ISLEME_DEVAM_ET = 'IslemeDevamEt';
    /**
     * Constant for value 'KullaniciUyarilacak'
     * @return string 'KullaniciUyarilacak'
     */
    const VALUE_KULLANICI_UYARILACAK = 'KullaniciUyarilacak';
    /**
     * Constant for value 'IslemDurdurulacak'
     * @return string 'IslemDurdurulacak'
     */
    const VALUE_ISLEM_DURDURULACAK = 'IslemDurdurulacak';
    /**
     * Constant for value 'Default'
     * @return string 'Default'
     */
    const VALUE_DEFAULT = 'Default';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ISLEME_DEVAM_ET
     * @uses self::VALUE_KULLANICI_UYARILACAK
     * @uses self::VALUE_ISLEM_DURDURULACAK
     * @uses self::VALUE_DEFAULT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ISLEME_DEVAM_ET,
            self::VALUE_KULLANICI_UYARILACAK,
            self::VALUE_ISLEM_DURDURULACAK,
            self::VALUE_DEFAULT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
