<?php

namespace fk_\EnumType;

/**
 * This class stands for KSozlesmeDurum EnumType
 * @subpackage Enumerations
 */
class KSozlesmeDurum
{
    /**
     * Constant for value 'Teklif'
     * @return string 'Teklif'
     */
    const VALUE_TEKLIF = 'Teklif';
    /**
     * Constant for value 'TeklifOnay'
     * @return string 'TeklifOnay'
     */
    const VALUE_TEKLIF_ONAY = 'TeklifOnay';
    /**
     * Constant for value 'Aktif'
     * @return string 'Aktif'
     */
    const VALUE_AKTIF = 'Aktif';
    /**
     * Constant for value 'Revizyon'
     * @return string 'Revizyon'
     */
    const VALUE_REVIZYON = 'Revizyon';
    /**
     * Constant for value 'RevizyonOnay'
     * @return string 'RevizyonOnay'
     */
    const VALUE_REVIZYON_ONAY = 'RevizyonOnay';
    /**
     * Constant for value 'Eski'
     * @return string 'Eski'
     */
    const VALUE_ESKI = 'Eski';
    /**
     * Constant for value 'Iptal'
     * @return string 'Iptal'
     */
    const VALUE_IPTAL = 'Iptal';
    /**
     * Constant for value 'TeklifOnOnay'
     * @return string 'TeklifOnOnay'
     */
    const VALUE_TEKLIF_ON_ONAY = 'TeklifOnOnay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEKLIF
     * @uses self::VALUE_TEKLIF_ONAY
     * @uses self::VALUE_AKTIF
     * @uses self::VALUE_REVIZYON
     * @uses self::VALUE_REVIZYON_ONAY
     * @uses self::VALUE_ESKI
     * @uses self::VALUE_IPTAL
     * @uses self::VALUE_TEKLIF_ON_ONAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEKLIF,
            self::VALUE_TEKLIF_ONAY,
            self::VALUE_AKTIF,
            self::VALUE_REVIZYON,
            self::VALUE_REVIZYON_ONAY,
            self::VALUE_ESKI,
            self::VALUE_IPTAL,
            self::VALUE_TEKLIF_ON_ONAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
