<?php

namespace fk_\EnumType;

/**
 * This class stands for SubeTip EnumType
 * @subpackage Enumerations
 */
class SubeTip
{
    /**
     * Constant for value 'Merkez'
     * @return string 'Merkez'
     */
    const VALUE_MERKEZ = 'Merkez';
    /**
     * Constant for value 'BolgeMudurluk'
     * @return string 'BolgeMudurluk'
     */
    const VALUE_BOLGE_MUDURLUK = 'BolgeMudurluk';
    /**
     * Constant for value 'BolgeTemsilcilik'
     * @return string 'BolgeTemsilcilik'
     */
    const VALUE_BOLGE_TEMSILCILIK = 'BolgeTemsilcilik';
    /**
     * Constant for value 'Sube'
     * @return string 'Sube'
     */
    const VALUE_SUBE = 'Sube';
    /**
     * Constant for value 'AktarmaMerkezi'
     * @return string 'AktarmaMerkezi'
     */
    const VALUE_AKTARMA_MERKEZI = 'AktarmaMerkezi';
    /**
     * Constant for value 'SanalSube'
     * @return string 'SanalSube'
     */
    const VALUE_SANAL_SUBE = 'SanalSube';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MERKEZ
     * @uses self::VALUE_BOLGE_MUDURLUK
     * @uses self::VALUE_BOLGE_TEMSILCILIK
     * @uses self::VALUE_SUBE
     * @uses self::VALUE_AKTARMA_MERKEZI
     * @uses self::VALUE_SANAL_SUBE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MERKEZ,
            self::VALUE_BOLGE_MUDURLUK,
            self::VALUE_BOLGE_TEMSILCILIK,
            self::VALUE_SUBE,
            self::VALUE_AKTARMA_MERKEZI,
            self::VALUE_SANAL_SUBE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
