<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KAraciFirmaHareket StructType
 * @subpackage Structs
 */
class KAraciFirmaHareket extends ValueEntity
{
    /**
     * The KDVOrani
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $KDVOrani;
    /**
     * The Tarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tarih;
    /**
     * The TakipNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TakipNo;
    /**
     * The AraciFirma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $AraciFirma;
    /**
     * The AraciFirmaSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $AraciFirmaSube;
    /**
     * The ToplamTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $ToplamTutar;
    /**
     * The KDVTutar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $KDVTutar;
    /**
     * The Faturasi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaPointer
     */
    public $Faturasi;
    /**
     * Constructor method for KAraciFirmaHareket
     * @uses KAraciFirmaHareket::setKDVOrani()
     * @uses KAraciFirmaHareket::setTarih()
     * @uses KAraciFirmaHareket::setTakipNo()
     * @uses KAraciFirmaHareket::setAraciFirma()
     * @uses KAraciFirmaHareket::setAraciFirmaSube()
     * @uses KAraciFirmaHareket::setToplamTutar()
     * @uses KAraciFirmaHareket::setKDVTutar()
     * @uses KAraciFirmaHareket::setFaturasi()
     * @param float $kDVOrani
     * @param string $tarih
     * @param string $takipNo
     * @param \fk_\StructType\KCariPointer $araciFirma
     * @param \fk_\StructType\KCariPointer $araciFirmaSube
     * @param \fk_\StructType\DovizliTutar $toplamTutar
     * @param \fk_\StructType\DovizliTutar $kDVTutar
     * @param \fk_\StructType\KFaturaPointer $faturasi
     */
    public function __construct($kDVOrani = null, $tarih = null, $takipNo = null, \fk_\StructType\KCariPointer $araciFirma = null, \fk_\StructType\KCariPointer $araciFirmaSube = null, \fk_\StructType\DovizliTutar $toplamTutar = null, \fk_\StructType\DovizliTutar $kDVTutar = null, \fk_\StructType\KFaturaPointer $faturasi = null)
    {
        $this
            ->setKDVOrani($kDVOrani)
            ->setTarih($tarih)
            ->setTakipNo($takipNo)
            ->setAraciFirma($araciFirma)
            ->setAraciFirmaSube($araciFirmaSube)
            ->setToplamTutar($toplamTutar)
            ->setKDVTutar($kDVTutar)
            ->setFaturasi($faturasi);
    }
    /**
     * Get KDVOrani value
     * @return float
     */
    public function getKDVOrani()
    {
        return $this->KDVOrani;
    }
    /**
     * Set KDVOrani value
     * @param float $kDVOrani
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setKDVOrani($kDVOrani = null)
    {
        // validation for constraint: float
        if (!is_null($kDVOrani) && !(is_float($kDVOrani) || is_numeric($kDVOrani))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($kDVOrani, true), gettype($kDVOrani)), __LINE__);
        }
        $this->KDVOrani = $kDVOrani;
        return $this;
    }
    /**
     * Get Tarih value
     * @return string
     */
    public function getTarih()
    {
        return $this->Tarih;
    }
    /**
     * Set Tarih value
     * @param string $tarih
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setTarih($tarih = null)
    {
        // validation for constraint: string
        if (!is_null($tarih) && !is_string($tarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tarih, true), gettype($tarih)), __LINE__);
        }
        $this->Tarih = $tarih;
        return $this;
    }
    /**
     * Get TakipNo value
     * @return string|null
     */
    public function getTakipNo()
    {
        return $this->TakipNo;
    }
    /**
     * Set TakipNo value
     * @param string $takipNo
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setTakipNo($takipNo = null)
    {
        // validation for constraint: string
        if (!is_null($takipNo) && !is_string($takipNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($takipNo, true), gettype($takipNo)), __LINE__);
        }
        $this->TakipNo = $takipNo;
        return $this;
    }
    /**
     * Get AraciFirma value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getAraciFirma()
    {
        return $this->AraciFirma;
    }
    /**
     * Set AraciFirma value
     * @param \fk_\StructType\KCariPointer $araciFirma
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setAraciFirma(\fk_\StructType\KCariPointer $araciFirma = null)
    {
        $this->AraciFirma = $araciFirma;
        return $this;
    }
    /**
     * Get AraciFirmaSube value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getAraciFirmaSube()
    {
        return $this->AraciFirmaSube;
    }
    /**
     * Set AraciFirmaSube value
     * @param \fk_\StructType\KCariPointer $araciFirmaSube
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setAraciFirmaSube(\fk_\StructType\KCariPointer $araciFirmaSube = null)
    {
        $this->AraciFirmaSube = $araciFirmaSube;
        return $this;
    }
    /**
     * Get ToplamTutar value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getToplamTutar()
    {
        return $this->ToplamTutar;
    }
    /**
     * Set ToplamTutar value
     * @param \fk_\StructType\DovizliTutar $toplamTutar
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setToplamTutar(\fk_\StructType\DovizliTutar $toplamTutar = null)
    {
        $this->ToplamTutar = $toplamTutar;
        return $this;
    }
    /**
     * Get KDVTutar value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getKDVTutar()
    {
        return $this->KDVTutar;
    }
    /**
     * Set KDVTutar value
     * @param \fk_\StructType\DovizliTutar $kDVTutar
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setKDVTutar(\fk_\StructType\DovizliTutar $kDVTutar = null)
    {
        $this->KDVTutar = $kDVTutar;
        return $this;
    }
    /**
     * Get Faturasi value
     * @return \fk_\StructType\KFaturaPointer|null
     */
    public function getFaturasi()
    {
        return $this->Faturasi;
    }
    /**
     * Set Faturasi value
     * @param \fk_\StructType\KFaturaPointer $faturasi
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public function setFaturasi(\fk_\StructType\KFaturaPointer $faturasi = null)
    {
        $this->Faturasi = $faturasi;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KAraciFirmaHareket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
