<?php

namespace fk_\EnumType;

/**
 * This class stands for PazarlamaciDurumu EnumType
 * @subpackage Enumerations
 */
class PazarlamaciDurumu
{
    /**
     * Constant for value 'Yok'
     * @return string 'Yok'
     */
    const VALUE_YOK = 'Yok';
    /**
     * Constant for value 'Var'
     * @return string 'Var'
     */
    const VALUE_VAR = 'Var';
    /**
     * Constant for value 'SecimZorunlu'
     * @return string 'SecimZorunlu'
     */
    const VALUE_SECIM_ZORUNLU = 'SecimZorunlu';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_YOK
     * @uses self::VALUE_VAR
     * @uses self::VALUE_SECIM_ZORUNLU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_YOK,
            self::VALUE_VAR,
            self::VALUE_SECIM_ZORUNLU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
