<?php

namespace fk_\EnumType;

/**
 * This class stands for KVergiMukellef EnumType
 * @subpackage Enumerations
 */
class KVergiMukellef
{
    /**
     * Constant for value 'VergiMukellefi'
     * @return string 'VergiMukellefi'
     */
    const VALUE_VERGI_MUKELLEFI = 'VergiMukellefi';
    /**
     * Constant for value 'VergiMukellefiDegil'
     * @return string 'VergiMukellefiDegil'
     */
    const VALUE_VERGI_MUKELLEFI_DEGIL = 'VergiMukellefiDegil';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_VERGI_MUKELLEFI
     * @uses self::VALUE_VERGI_MUKELLEFI_DEGIL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VERGI_MUKELLEFI,
            self::VALUE_VERGI_MUKELLEFI_DEGIL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
