<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adres StructType
 * @subpackage Structs
 */
class Adres extends ValueEntity
{
    /**
     * The Ilcesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\IlcePointer
     */
    public $Ilcesi;
    /**
     * The Ili
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\IlPointer
     */
    public $Ili;
    /**
     * The Ulkesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\UlkePointer
     */
    public $Ulkesi;
    /**
     * The AdresSatiri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AdresSatiri;
    /**
     * The Mahalle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mahalle;
    /**
     * The Semt
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Semt;
    /**
     * The PostaKodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostaKodu;
    /**
     * The BinaNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BinaNo;
    /**
     * The Sokak
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sokak;
    /**
     * The Cadde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cadde;
    /**
     * Constructor method for Adres
     * @uses Adres::setIlcesi()
     * @uses Adres::setIli()
     * @uses Adres::setUlkesi()
     * @uses Adres::setAdresSatiri()
     * @uses Adres::setMahalle()
     * @uses Adres::setSemt()
     * @uses Adres::setPostaKodu()
     * @uses Adres::setBinaNo()
     * @uses Adres::setSokak()
     * @uses Adres::setCadde()
     * @param \fk_\StructType\IlcePointer $ilcesi
     * @param \fk_\StructType\IlPointer $ili
     * @param \fk_\StructType\UlkePointer $ulkesi
     * @param string $adresSatiri
     * @param string $mahalle
     * @param string $semt
     * @param string $postaKodu
     * @param string $binaNo
     * @param string $sokak
     * @param string $cadde
     */
    public function __construct(\fk_\StructType\IlcePointer $ilcesi = null, \fk_\StructType\IlPointer $ili = null, \fk_\StructType\UlkePointer $ulkesi = null, $adresSatiri = null, $mahalle = null, $semt = null, $postaKodu = null, $binaNo = null, $sokak = null, $cadde = null)
    {
        $this
            ->setIlcesi($ilcesi)
            ->setIli($ili)
            ->setUlkesi($ulkesi)
            ->setAdresSatiri($adresSatiri)
            ->setMahalle($mahalle)
            ->setSemt($semt)
            ->setPostaKodu($postaKodu)
            ->setBinaNo($binaNo)
            ->setSokak($sokak)
            ->setCadde($cadde);
    }
    /**
     * Get Ilcesi value
     * @return \fk_\StructType\IlcePointer|null
     */
    public function getIlcesi()
    {
        return $this->Ilcesi;
    }
    /**
     * Set Ilcesi value
     * @param \fk_\StructType\IlcePointer $ilcesi
     * @return \fk_\StructType\Adres
     */
    public function setIlcesi(\fk_\StructType\IlcePointer $ilcesi = null)
    {
        $this->Ilcesi = $ilcesi;
        return $this;
    }
    /**
     * Get Ili value
     * @return \fk_\StructType\IlPointer|null
     */
    public function getIli()
    {
        return $this->Ili;
    }
    /**
     * Set Ili value
     * @param \fk_\StructType\IlPointer $ili
     * @return \fk_\StructType\Adres
     */
    public function setIli(\fk_\StructType\IlPointer $ili = null)
    {
        $this->Ili = $ili;
        return $this;
    }
    /**
     * Get Ulkesi value
     * @return \fk_\StructType\UlkePointer|null
     */
    public function getUlkesi()
    {
        return $this->Ulkesi;
    }
    /**
     * Set Ulkesi value
     * @param \fk_\StructType\UlkePointer $ulkesi
     * @return \fk_\StructType\Adres
     */
    public function setUlkesi(\fk_\StructType\UlkePointer $ulkesi = null)
    {
        $this->Ulkesi = $ulkesi;
        return $this;
    }
    /**
     * Get AdresSatiri value
     * @return string|null
     */
    public function getAdresSatiri()
    {
        return $this->AdresSatiri;
    }
    /**
     * Set AdresSatiri value
     * @param string $adresSatiri
     * @return \fk_\StructType\Adres
     */
    public function setAdresSatiri($adresSatiri = null)
    {
        // validation for constraint: string
        if (!is_null($adresSatiri) && !is_string($adresSatiri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresSatiri, true), gettype($adresSatiri)), __LINE__);
        }
        $this->AdresSatiri = $adresSatiri;
        return $this;
    }
    /**
     * Get Mahalle value
     * @return string|null
     */
    public function getMahalle()
    {
        return $this->Mahalle;
    }
    /**
     * Set Mahalle value
     * @param string $mahalle
     * @return \fk_\StructType\Adres
     */
    public function setMahalle($mahalle = null)
    {
        // validation for constraint: string
        if (!is_null($mahalle) && !is_string($mahalle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mahalle, true), gettype($mahalle)), __LINE__);
        }
        $this->Mahalle = $mahalle;
        return $this;
    }
    /**
     * Get Semt value
     * @return string|null
     */
    public function getSemt()
    {
        return $this->Semt;
    }
    /**
     * Set Semt value
     * @param string $semt
     * @return \fk_\StructType\Adres
     */
    public function setSemt($semt = null)
    {
        // validation for constraint: string
        if (!is_null($semt) && !is_string($semt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($semt, true), gettype($semt)), __LINE__);
        }
        $this->Semt = $semt;
        return $this;
    }
    /**
     * Get PostaKodu value
     * @return string|null
     */
    public function getPostaKodu()
    {
        return $this->PostaKodu;
    }
    /**
     * Set PostaKodu value
     * @param string $postaKodu
     * @return \fk_\StructType\Adres
     */
    public function setPostaKodu($postaKodu = null)
    {
        // validation for constraint: string
        if (!is_null($postaKodu) && !is_string($postaKodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postaKodu, true), gettype($postaKodu)), __LINE__);
        }
        $this->PostaKodu = $postaKodu;
        return $this;
    }
    /**
     * Get BinaNo value
     * @return string|null
     */
    public function getBinaNo()
    {
        return $this->BinaNo;
    }
    /**
     * Set BinaNo value
     * @param string $binaNo
     * @return \fk_\StructType\Adres
     */
    public function setBinaNo($binaNo = null)
    {
        // validation for constraint: string
        if (!is_null($binaNo) && !is_string($binaNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binaNo, true), gettype($binaNo)), __LINE__);
        }
        $this->BinaNo = $binaNo;
        return $this;
    }
    /**
     * Get Sokak value
     * @return string|null
     */
    public function getSokak()
    {
        return $this->Sokak;
    }
    /**
     * Set Sokak value
     * @param string $sokak
     * @return \fk_\StructType\Adres
     */
    public function setSokak($sokak = null)
    {
        // validation for constraint: string
        if (!is_null($sokak) && !is_string($sokak)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sokak, true), gettype($sokak)), __LINE__);
        }
        $this->Sokak = $sokak;
        return $this;
    }
    /**
     * Get Cadde value
     * @return string|null
     */
    public function getCadde()
    {
        return $this->Cadde;
    }
    /**
     * Set Cadde value
     * @param string $cadde
     * @return \fk_\StructType\Adres
     */
    public function setCadde($cadde = null)
    {
        // validation for constraint: string
        if (!is_null($cadde) && !is_string($cadde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cadde, true), gettype($cadde)), __LINE__);
        }
        $this->Cadde = $cadde;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\Adres
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
