<?php

namespace fk_\EnumType;

/**
 * This class stands for KAracHakEdisDurum EnumType
 * @subpackage Enumerations
 */
class KAracHakEdisDurum
{
    /**
     * Constant for value 'Teklif'
     * @return string 'Teklif'
     */
    const VALUE_TEKLIF = 'Teklif';
    /**
     * Constant for value 'TeklifOnay'
     * @return string 'TeklifOnay'
     */
    const VALUE_TEKLIF_ONAY = 'TeklifOnay';
    /**
     * Constant for value 'TeklifRed'
     * @return string 'TeklifRed'
     */
    const VALUE_TEKLIF_RED = 'TeklifRed';
    /**
     * Constant for value 'UlastirmaOnay'
     * @return string 'UlastirmaOnay'
     */
    const VALUE_ULASTIRMA_ONAY = 'UlastirmaOnay';
    /**
     * Constant for value 'UlastirmaRed'
     * @return string 'UlastirmaRed'
     */
    const VALUE_ULASTIRMA_RED = 'UlastirmaRed';
    /**
     * Constant for value 'Faturalanabilir'
     * @return string 'Faturalanabilir'
     */
    const VALUE_FATURALANABILIR = 'Faturalanabilir';
    /**
     * Constant for value 'Faturalandi'
     * @return string 'Faturalandi'
     */
    const VALUE_FATURALANDI = 'Faturalandi';
    /**
     * Constant for value 'Iptal'
     * @return string 'Iptal'
     */
    const VALUE_IPTAL = 'Iptal';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEKLIF
     * @uses self::VALUE_TEKLIF_ONAY
     * @uses self::VALUE_TEKLIF_RED
     * @uses self::VALUE_ULASTIRMA_ONAY
     * @uses self::VALUE_ULASTIRMA_RED
     * @uses self::VALUE_FATURALANABILIR
     * @uses self::VALUE_FATURALANDI
     * @uses self::VALUE_IPTAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEKLIF,
            self::VALUE_TEKLIF_ONAY,
            self::VALUE_TEKLIF_RED,
            self::VALUE_ULASTIRMA_ONAY,
            self::VALUE_ULASTIRMA_RED,
            self::VALUE_FATURALANABILIR,
            self::VALUE_FATURALANDI,
            self::VALUE_IPTAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
