<?php

namespace fk_\EnumType;

/**
 * This class stands for ProjeTuru EnumType
 * @subpackage Enumerations
 */
class ProjeTuru
{
    /**
     * Constant for value 'Proje'
     * @return string 'Proje'
     */
    const VALUE_PROJE = 'Proje';
    /**
     * Constant for value 'İhale'
     * @return string 'İhale'
     */
    const VALUE_İHALE = 'İhale';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PROJE
     * @uses self::VALUE_İHALE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PROJE,
            self::VALUE_İHALE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
