<?php

namespace fk_\EnumType;

/**
 * This class stands for MalzemeSatisFiyatTipleri EnumType
 * @subpackage Enumerations
 */
class MalzemeSatisFiyatTipleri
{
    /**
     * Constant for value 'Alis'
     * @return string 'Alis'
     */
    const VALUE_ALIS = 'Alis';
    /**
     * Constant for value 'SonAlis'
     * @return string 'SonAlis'
     */
    const VALUE_SON_ALIS = 'SonAlis';
    /**
     * Constant for value 'CariSonAlis'
     * @return string 'CariSonAlis'
     */
    const VALUE_CARI_SON_ALIS = 'CariSonAlis';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ALIS
     * @uses self::VALUE_SON_ALIS
     * @uses self::VALUE_CARI_SON_ALIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ALIS,
            self::VALUE_SON_ALIS,
            self::VALUE_CARI_SON_ALIS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
