<?php

namespace fk_\EnumType;

/**
 * This class stands for AktarimEvrakTuru EnumType
 * @subpackage Enumerations
 */
class AktarimEvrakTuru
{
    /**
     * Constant for value 'Fatura'
     * @return string 'Fatura'
     */
    const VALUE_FATURA = 'Fatura';
    /**
     * Constant for value 'SevkIrsaliyesi'
     * @return string 'SevkIrsaliyesi'
     */
    const VALUE_SEVK_IRSALIYESI = 'SevkIrsaliyesi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FATURA
     * @uses self::VALUE_SEVK_IRSALIYESI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FATURA,
            self::VALUE_SEVK_IRSALIYESI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
