<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KFatura StructType
 * @subpackage Structs
 */
class KFatura extends TESFAT
{
    /**
     * The IsSatis
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSatis;
    /**
     * The FaturaTuru
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FaturaTuru;
    /**
     * The OdemeSekli
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemeSekli;
    /**
     * The SatistakiFaturaObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SatistakiFaturaObjId;
    /**
     * The FaturaninTamamininOdendigiTarih
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FaturaninTamamininOdendigiTarih;
    /**
     * The OdemeTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OdemeTarihi;
    /**
     * The BorcVirmanFisiObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $BorcVirmanFisiObjId;
    /**
     * The IadeMi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IadeMi;
    /**
     * The CariHesabiObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CariHesabiObjId;
    /**
     * The VirmanSebep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $VirmanSebep;
    /**
     * The IsKampanyaSozlemesiKullanabilir
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKampanyaSozlemesiKullanabilir;
    /**
     * The IsMedlineSozlesmesi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMedlineSozlesmesi;
    /**
     * The IsKekFaturasindanOlusan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKekFaturasindanOlusan;
    /**
     * The EFaturaSenaryosu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EFaturaSenaryosu;
    /**
     * The IsTesellumdenFaturaIcinEphHesaplansin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTesellumdenFaturaIcinEphHesaplansin;
    /**
     * The IsPov
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPov;
    /**
     * The FaturaUnvan
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaturaUnvan;
    /**
     * The FaturaAdres1
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaturaAdres1;
    /**
     * The FaturaAdres2
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FaturaAdres2;
    /**
     * The BagliOlduguFatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaPointer
     */
    public $BagliOlduguFatura;
    /**
     * The IadeFatura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaPointer
     */
    public $IadeFatura;
    /**
     * The IadeTesellumu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KTesellumPointer
     */
    public $IadeTesellumu;
    /**
     * The KampanyaSifresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $KampanyaSifresi;
    /**
     * The MedLineKartNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MedLineKartNo;
    /**
     * The FaturaEkBilgi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KFaturaEkBilgi
     */
    public $FaturaEkBilgi;
    /**
     * The dtTesellumObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DtTesellumObjId
     */
    public $dtTesellumObjId;
    /**
     * The TevkifEdilenKDV
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\DovizliTutar
     */
    public $TevkifEdilenKDV;
    /**
     * Constructor method for KFatura
     * @uses KFatura::setIsSatis()
     * @uses KFatura::setFaturaTuru()
     * @uses KFatura::setOdemeSekli()
     * @uses KFatura::setSatistakiFaturaObjId()
     * @uses KFatura::setFaturaninTamamininOdendigiTarih()
     * @uses KFatura::setOdemeTarihi()
     * @uses KFatura::setBorcVirmanFisiObjId()
     * @uses KFatura::setIadeMi()
     * @uses KFatura::setCariHesabiObjId()
     * @uses KFatura::setVirmanSebep()
     * @uses KFatura::setIsKampanyaSozlemesiKullanabilir()
     * @uses KFatura::setIsMedlineSozlesmesi()
     * @uses KFatura::setIsKekFaturasindanOlusan()
     * @uses KFatura::setEFaturaSenaryosu()
     * @uses KFatura::setIsTesellumdenFaturaIcinEphHesaplansin()
     * @uses KFatura::setIsPov()
     * @uses KFatura::setFaturaUnvan()
     * @uses KFatura::setFaturaAdres1()
     * @uses KFatura::setFaturaAdres2()
     * @uses KFatura::setBagliOlduguFatura()
     * @uses KFatura::setIadeFatura()
     * @uses KFatura::setIadeTesellumu()
     * @uses KFatura::setKampanyaSifresi()
     * @uses KFatura::setMedLineKartNo()
     * @uses KFatura::setFaturaEkBilgi()
     * @uses KFatura::setDtTesellumObjId()
     * @uses KFatura::setTevkifEdilenKDV()
     * @param bool $isSatis
     * @param string $faturaTuru
     * @param string $odemeSekli
     * @param int $satistakiFaturaObjId
     * @param string $faturaninTamamininOdendigiTarih
     * @param string $odemeTarihi
     * @param int $borcVirmanFisiObjId
     * @param bool $iadeMi
     * @param int $cariHesabiObjId
     * @param string $virmanSebep
     * @param bool $isKampanyaSozlemesiKullanabilir
     * @param bool $isMedlineSozlesmesi
     * @param bool $isKekFaturasindanOlusan
     * @param string $eFaturaSenaryosu
     * @param bool $isTesellumdenFaturaIcinEphHesaplansin
     * @param bool $isPov
     * @param string $faturaUnvan
     * @param string $faturaAdres1
     * @param string $faturaAdres2
     * @param \fk_\StructType\KFaturaPointer $bagliOlduguFatura
     * @param \fk_\StructType\KFaturaPointer $iadeFatura
     * @param \fk_\StructType\KTesellumPointer $iadeTesellumu
     * @param string $kampanyaSifresi
     * @param string $medLineKartNo
     * @param \fk_\StructType\KFaturaEkBilgi $faturaEkBilgi
     * @param \fk_\StructType\DtTesellumObjId $dtTesellumObjId
     * @param \fk_\StructType\DovizliTutar $tevkifEdilenKDV
     */
    public function __construct($isSatis = null, $faturaTuru = null, $odemeSekli = null, $satistakiFaturaObjId = null, $faturaninTamamininOdendigiTarih = null, $odemeTarihi = null, $borcVirmanFisiObjId = null, $iadeMi = null, $cariHesabiObjId = null, $virmanSebep = null, $isKampanyaSozlemesiKullanabilir = null, $isMedlineSozlesmesi = null, $isKekFaturasindanOlusan = null, $eFaturaSenaryosu = null, $isTesellumdenFaturaIcinEphHesaplansin = null, $isPov = null, $faturaUnvan = null, $faturaAdres1 = null, $faturaAdres2 = null, \fk_\StructType\KFaturaPointer $bagliOlduguFatura = null, \fk_\StructType\KFaturaPointer $iadeFatura = null, \fk_\StructType\KTesellumPointer $iadeTesellumu = null, $kampanyaSifresi = null, $medLineKartNo = null, \fk_\StructType\KFaturaEkBilgi $faturaEkBilgi = null, \fk_\StructType\DtTesellumObjId $dtTesellumObjId = null, \fk_\StructType\DovizliTutar $tevkifEdilenKDV = null)
    {
        $this
            ->setIsSatis($isSatis)
            ->setFaturaTuru($faturaTuru)
            ->setOdemeSekli($odemeSekli)
            ->setSatistakiFaturaObjId($satistakiFaturaObjId)
            ->setFaturaninTamamininOdendigiTarih($faturaninTamamininOdendigiTarih)
            ->setOdemeTarihi($odemeTarihi)
            ->setBorcVirmanFisiObjId($borcVirmanFisiObjId)
            ->setIadeMi($iadeMi)
            ->setCariHesabiObjId($cariHesabiObjId)
            ->setVirmanSebep($virmanSebep)
            ->setIsKampanyaSozlemesiKullanabilir($isKampanyaSozlemesiKullanabilir)
            ->setIsMedlineSozlesmesi($isMedlineSozlesmesi)
            ->setIsKekFaturasindanOlusan($isKekFaturasindanOlusan)
            ->setEFaturaSenaryosu($eFaturaSenaryosu)
            ->setIsTesellumdenFaturaIcinEphHesaplansin($isTesellumdenFaturaIcinEphHesaplansin)
            ->setIsPov($isPov)
            ->setFaturaUnvan($faturaUnvan)
            ->setFaturaAdres1($faturaAdres1)
            ->setFaturaAdres2($faturaAdres2)
            ->setBagliOlduguFatura($bagliOlduguFatura)
            ->setIadeFatura($iadeFatura)
            ->setIadeTesellumu($iadeTesellumu)
            ->setKampanyaSifresi($kampanyaSifresi)
            ->setMedLineKartNo($medLineKartNo)
            ->setFaturaEkBilgi($faturaEkBilgi)
            ->setDtTesellumObjId($dtTesellumObjId)
            ->setTevkifEdilenKDV($tevkifEdilenKDV);
    }
    /**
     * Get IsSatis value
     * @return bool
     */
    public function getIsSatis()
    {
        return $this->IsSatis;
    }
    /**
     * Set IsSatis value
     * @param bool $isSatis
     * @return \fk_\StructType\KFatura
     */
    public function setIsSatis($isSatis = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSatis) && !is_bool($isSatis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSatis, true), gettype($isSatis)), __LINE__);
        }
        $this->IsSatis = $isSatis;
        return $this;
    }
    /**
     * Get FaturaTuru value
     * @return string
     */
    public function getFaturaTuru()
    {
        return $this->FaturaTuru;
    }
    /**
     * Set FaturaTuru value
     * @uses \fk_\EnumType\KEvrakTurleri::valueIsValid()
     * @uses \fk_\EnumType\KEvrakTurleri::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $faturaTuru
     * @return \fk_\StructType\KFatura
     */
    public function setFaturaTuru($faturaTuru = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KEvrakTurleri::valueIsValid($faturaTuru)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KEvrakTurleri', is_array($faturaTuru) ? implode(', ', $faturaTuru) : var_export($faturaTuru, true), implode(', ', \fk_\EnumType\KEvrakTurleri::getValidValues())), __LINE__);
        }
        $this->FaturaTuru = $faturaTuru;
        return $this;
    }
    /**
     * Get OdemeSekli value
     * @return string
     */
    public function getOdemeSekli()
    {
        return $this->OdemeSekli;
    }
    /**
     * Set OdemeSekli value
     * @uses \fk_\EnumType\KFaturaOdemeSekli::valueIsValid()
     * @uses \fk_\EnumType\KFaturaOdemeSekli::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $odemeSekli
     * @return \fk_\StructType\KFatura
     */
    public function setOdemeSekli($odemeSekli = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\KFaturaOdemeSekli::valueIsValid($odemeSekli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\KFaturaOdemeSekli', is_array($odemeSekli) ? implode(', ', $odemeSekli) : var_export($odemeSekli, true), implode(', ', \fk_\EnumType\KFaturaOdemeSekli::getValidValues())), __LINE__);
        }
        $this->OdemeSekli = $odemeSekli;
        return $this;
    }
    /**
     * Get SatistakiFaturaObjId value
     * @return int
     */
    public function getSatistakiFaturaObjId()
    {
        return $this->SatistakiFaturaObjId;
    }
    /**
     * Set SatistakiFaturaObjId value
     * @param int $satistakiFaturaObjId
     * @return \fk_\StructType\KFatura
     */
    public function setSatistakiFaturaObjId($satistakiFaturaObjId = null)
    {
        // validation for constraint: int
        if (!is_null($satistakiFaturaObjId) && !(is_int($satistakiFaturaObjId) || ctype_digit($satistakiFaturaObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($satistakiFaturaObjId, true), gettype($satistakiFaturaObjId)), __LINE__);
        }
        $this->SatistakiFaturaObjId = $satistakiFaturaObjId;
        return $this;
    }
    /**
     * Get FaturaninTamamininOdendigiTarih value
     * @return string
     */
    public function getFaturaninTamamininOdendigiTarih()
    {
        return $this->FaturaninTamamininOdendigiTarih;
    }
    /**
     * Set FaturaninTamamininOdendigiTarih value
     * @param string $faturaninTamamininOdendigiTarih
     * @return \fk_\StructType\KFatura
     */
    public function setFaturaninTamamininOdendigiTarih($faturaninTamamininOdendigiTarih = null)
    {
        // validation for constraint: string
        if (!is_null($faturaninTamamininOdendigiTarih) && !is_string($faturaninTamamininOdendigiTarih)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaninTamamininOdendigiTarih, true), gettype($faturaninTamamininOdendigiTarih)), __LINE__);
        }
        $this->FaturaninTamamininOdendigiTarih = $faturaninTamamininOdendigiTarih;
        return $this;
    }
    /**
     * Get OdemeTarihi value
     * @return string
     */
    public function getOdemeTarihi()
    {
        return $this->OdemeTarihi;
    }
    /**
     * Set OdemeTarihi value
     * @param string $odemeTarihi
     * @return \fk_\StructType\KFatura
     */
    public function setOdemeTarihi($odemeTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($odemeTarihi) && !is_string($odemeTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($odemeTarihi, true), gettype($odemeTarihi)), __LINE__);
        }
        $this->OdemeTarihi = $odemeTarihi;
        return $this;
    }
    /**
     * Get BorcVirmanFisiObjId value
     * @return int
     */
    public function getBorcVirmanFisiObjId()
    {
        return $this->BorcVirmanFisiObjId;
    }
    /**
     * Set BorcVirmanFisiObjId value
     * @param int $borcVirmanFisiObjId
     * @return \fk_\StructType\KFatura
     */
    public function setBorcVirmanFisiObjId($borcVirmanFisiObjId = null)
    {
        // validation for constraint: int
        if (!is_null($borcVirmanFisiObjId) && !(is_int($borcVirmanFisiObjId) || ctype_digit($borcVirmanFisiObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($borcVirmanFisiObjId, true), gettype($borcVirmanFisiObjId)), __LINE__);
        }
        $this->BorcVirmanFisiObjId = $borcVirmanFisiObjId;
        return $this;
    }
    /**
     * Get IadeMi value
     * @return bool
     */
    public function getIadeMi()
    {
        return $this->IadeMi;
    }
    /**
     * Set IadeMi value
     * @param bool $iadeMi
     * @return \fk_\StructType\KFatura
     */
    public function setIadeMi($iadeMi = null)
    {
        // validation for constraint: boolean
        if (!is_null($iadeMi) && !is_bool($iadeMi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($iadeMi, true), gettype($iadeMi)), __LINE__);
        }
        $this->IadeMi = $iadeMi;
        return $this;
    }
    /**
     * Get CariHesabiObjId value
     * @return int
     */
    public function getCariHesabiObjId()
    {
        return $this->CariHesabiObjId;
    }
    /**
     * Set CariHesabiObjId value
     * @param int $cariHesabiObjId
     * @return \fk_\StructType\KFatura
     */
    public function setCariHesabiObjId($cariHesabiObjId = null)
    {
        // validation for constraint: int
        if (!is_null($cariHesabiObjId) && !(is_int($cariHesabiObjId) || ctype_digit($cariHesabiObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cariHesabiObjId, true), gettype($cariHesabiObjId)), __LINE__);
        }
        $this->CariHesabiObjId = $cariHesabiObjId;
        return $this;
    }
    /**
     * Get VirmanSebep value
     * @return string
     */
    public function getVirmanSebep()
    {
        return $this->VirmanSebep;
    }
    /**
     * Set VirmanSebep value
     * @uses \fk_\EnumType\VirmanSebep::valueIsValid()
     * @uses \fk_\EnumType\VirmanSebep::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $virmanSebep
     * @return \fk_\StructType\KFatura
     */
    public function setVirmanSebep($virmanSebep = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\VirmanSebep::valueIsValid($virmanSebep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\VirmanSebep', is_array($virmanSebep) ? implode(', ', $virmanSebep) : var_export($virmanSebep, true), implode(', ', \fk_\EnumType\VirmanSebep::getValidValues())), __LINE__);
        }
        $this->VirmanSebep = $virmanSebep;
        return $this;
    }
    /**
     * Get IsKampanyaSozlemesiKullanabilir value
     * @return bool
     */
    public function getIsKampanyaSozlemesiKullanabilir()
    {
        return $this->IsKampanyaSozlemesiKullanabilir;
    }
    /**
     * Set IsKampanyaSozlemesiKullanabilir value
     * @param bool $isKampanyaSozlemesiKullanabilir
     * @return \fk_\StructType\KFatura
     */
    public function setIsKampanyaSozlemesiKullanabilir($isKampanyaSozlemesiKullanabilir = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKampanyaSozlemesiKullanabilir) && !is_bool($isKampanyaSozlemesiKullanabilir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKampanyaSozlemesiKullanabilir, true), gettype($isKampanyaSozlemesiKullanabilir)), __LINE__);
        }
        $this->IsKampanyaSozlemesiKullanabilir = $isKampanyaSozlemesiKullanabilir;
        return $this;
    }
    /**
     * Get IsMedlineSozlesmesi value
     * @return bool
     */
    public function getIsMedlineSozlesmesi()
    {
        return $this->IsMedlineSozlesmesi;
    }
    /**
     * Set IsMedlineSozlesmesi value
     * @param bool $isMedlineSozlesmesi
     * @return \fk_\StructType\KFatura
     */
    public function setIsMedlineSozlesmesi($isMedlineSozlesmesi = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMedlineSozlesmesi) && !is_bool($isMedlineSozlesmesi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMedlineSozlesmesi, true), gettype($isMedlineSozlesmesi)), __LINE__);
        }
        $this->IsMedlineSozlesmesi = $isMedlineSozlesmesi;
        return $this;
    }
    /**
     * Get IsKekFaturasindanOlusan value
     * @return bool
     */
    public function getIsKekFaturasindanOlusan()
    {
        return $this->IsKekFaturasindanOlusan;
    }
    /**
     * Set IsKekFaturasindanOlusan value
     * @param bool $isKekFaturasindanOlusan
     * @return \fk_\StructType\KFatura
     */
    public function setIsKekFaturasindanOlusan($isKekFaturasindanOlusan = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKekFaturasindanOlusan) && !is_bool($isKekFaturasindanOlusan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKekFaturasindanOlusan, true), gettype($isKekFaturasindanOlusan)), __LINE__);
        }
        $this->IsKekFaturasindanOlusan = $isKekFaturasindanOlusan;
        return $this;
    }
    /**
     * Get EFaturaSenaryosu value
     * @return string
     */
    public function getEFaturaSenaryosu()
    {
        return $this->EFaturaSenaryosu;
    }
    /**
     * Set EFaturaSenaryosu value
     * @uses \fk_\EnumType\EFaturaSenaryosu::valueIsValid()
     * @uses \fk_\EnumType\EFaturaSenaryosu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eFaturaSenaryosu
     * @return \fk_\StructType\KFatura
     */
    public function setEFaturaSenaryosu($eFaturaSenaryosu = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\EFaturaSenaryosu::valueIsValid($eFaturaSenaryosu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\EFaturaSenaryosu', is_array($eFaturaSenaryosu) ? implode(', ', $eFaturaSenaryosu) : var_export($eFaturaSenaryosu, true), implode(', ', \fk_\EnumType\EFaturaSenaryosu::getValidValues())), __LINE__);
        }
        $this->EFaturaSenaryosu = $eFaturaSenaryosu;
        return $this;
    }
    /**
     * Get IsTesellumdenFaturaIcinEphHesaplansin value
     * @return bool
     */
    public function getIsTesellumdenFaturaIcinEphHesaplansin()
    {
        return $this->IsTesellumdenFaturaIcinEphHesaplansin;
    }
    /**
     * Set IsTesellumdenFaturaIcinEphHesaplansin value
     * @param bool $isTesellumdenFaturaIcinEphHesaplansin
     * @return \fk_\StructType\KFatura
     */
    public function setIsTesellumdenFaturaIcinEphHesaplansin($isTesellumdenFaturaIcinEphHesaplansin = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTesellumdenFaturaIcinEphHesaplansin) && !is_bool($isTesellumdenFaturaIcinEphHesaplansin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTesellumdenFaturaIcinEphHesaplansin, true), gettype($isTesellumdenFaturaIcinEphHesaplansin)), __LINE__);
        }
        $this->IsTesellumdenFaturaIcinEphHesaplansin = $isTesellumdenFaturaIcinEphHesaplansin;
        return $this;
    }
    /**
     * Get IsPov value
     * @return bool
     */
    public function getIsPov()
    {
        return $this->IsPov;
    }
    /**
     * Set IsPov value
     * @param bool $isPov
     * @return \fk_\StructType\KFatura
     */
    public function setIsPov($isPov = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPov) && !is_bool($isPov)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPov, true), gettype($isPov)), __LINE__);
        }
        $this->IsPov = $isPov;
        return $this;
    }
    /**
     * Get FaturaUnvan value
     * @return string|null
     */
    public function getFaturaUnvan()
    {
        return $this->FaturaUnvan;
    }
    /**
     * Set FaturaUnvan value
     * @param string $faturaUnvan
     * @return \fk_\StructType\KFatura
     */
    public function setFaturaUnvan($faturaUnvan = null)
    {
        // validation for constraint: string
        if (!is_null($faturaUnvan) && !is_string($faturaUnvan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaUnvan, true), gettype($faturaUnvan)), __LINE__);
        }
        $this->FaturaUnvan = $faturaUnvan;
        return $this;
    }
    /**
     * Get FaturaAdres1 value
     * @return string|null
     */
    public function getFaturaAdres1()
    {
        return $this->FaturaAdres1;
    }
    /**
     * Set FaturaAdres1 value
     * @param string $faturaAdres1
     * @return \fk_\StructType\KFatura
     */
    public function setFaturaAdres1($faturaAdres1 = null)
    {
        // validation for constraint: string
        if (!is_null($faturaAdres1) && !is_string($faturaAdres1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaAdres1, true), gettype($faturaAdres1)), __LINE__);
        }
        $this->FaturaAdres1 = $faturaAdres1;
        return $this;
    }
    /**
     * Get FaturaAdres2 value
     * @return string|null
     */
    public function getFaturaAdres2()
    {
        return $this->FaturaAdres2;
    }
    /**
     * Set FaturaAdres2 value
     * @param string $faturaAdres2
     * @return \fk_\StructType\KFatura
     */
    public function setFaturaAdres2($faturaAdres2 = null)
    {
        // validation for constraint: string
        if (!is_null($faturaAdres2) && !is_string($faturaAdres2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faturaAdres2, true), gettype($faturaAdres2)), __LINE__);
        }
        $this->FaturaAdres2 = $faturaAdres2;
        return $this;
    }
    /**
     * Get BagliOlduguFatura value
     * @return \fk_\StructType\KFaturaPointer|null
     */
    public function getBagliOlduguFatura()
    {
        return $this->BagliOlduguFatura;
    }
    /**
     * Set BagliOlduguFatura value
     * @param \fk_\StructType\KFaturaPointer $bagliOlduguFatura
     * @return \fk_\StructType\KFatura
     */
    public function setBagliOlduguFatura(\fk_\StructType\KFaturaPointer $bagliOlduguFatura = null)
    {
        $this->BagliOlduguFatura = $bagliOlduguFatura;
        return $this;
    }
    /**
     * Get IadeFatura value
     * @return \fk_\StructType\KFaturaPointer|null
     */
    public function getIadeFatura()
    {
        return $this->IadeFatura;
    }
    /**
     * Set IadeFatura value
     * @param \fk_\StructType\KFaturaPointer $iadeFatura
     * @return \fk_\StructType\KFatura
     */
    public function setIadeFatura(\fk_\StructType\KFaturaPointer $iadeFatura = null)
    {
        $this->IadeFatura = $iadeFatura;
        return $this;
    }
    /**
     * Get IadeTesellumu value
     * @return \fk_\StructType\KTesellumPointer|null
     */
    public function getIadeTesellumu()
    {
        return $this->IadeTesellumu;
    }
    /**
     * Set IadeTesellumu value
     * @param \fk_\StructType\KTesellumPointer $iadeTesellumu
     * @return \fk_\StructType\KFatura
     */
    public function setIadeTesellumu(\fk_\StructType\KTesellumPointer $iadeTesellumu = null)
    {
        $this->IadeTesellumu = $iadeTesellumu;
        return $this;
    }
    /**
     * Get KampanyaSifresi value
     * @return string|null
     */
    public function getKampanyaSifresi()
    {
        return $this->KampanyaSifresi;
    }
    /**
     * Set KampanyaSifresi value
     * @param string $kampanyaSifresi
     * @return \fk_\StructType\KFatura
     */
    public function setKampanyaSifresi($kampanyaSifresi = null)
    {
        // validation for constraint: string
        if (!is_null($kampanyaSifresi) && !is_string($kampanyaSifresi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kampanyaSifresi, true), gettype($kampanyaSifresi)), __LINE__);
        }
        $this->KampanyaSifresi = $kampanyaSifresi;
        return $this;
    }
    /**
     * Get MedLineKartNo value
     * @return string|null
     */
    public function getMedLineKartNo()
    {
        return $this->MedLineKartNo;
    }
    /**
     * Set MedLineKartNo value
     * @param string $medLineKartNo
     * @return \fk_\StructType\KFatura
     */
    public function setMedLineKartNo($medLineKartNo = null)
    {
        // validation for constraint: string
        if (!is_null($medLineKartNo) && !is_string($medLineKartNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($medLineKartNo, true), gettype($medLineKartNo)), __LINE__);
        }
        $this->MedLineKartNo = $medLineKartNo;
        return $this;
    }
    /**
     * Get FaturaEkBilgi value
     * @return \fk_\StructType\KFaturaEkBilgi|null
     */
    public function getFaturaEkBilgi()
    {
        return $this->FaturaEkBilgi;
    }
    /**
     * Set FaturaEkBilgi value
     * @param \fk_\StructType\KFaturaEkBilgi $faturaEkBilgi
     * @return \fk_\StructType\KFatura
     */
    public function setFaturaEkBilgi(\fk_\StructType\KFaturaEkBilgi $faturaEkBilgi = null)
    {
        $this->FaturaEkBilgi = $faturaEkBilgi;
        return $this;
    }
    /**
     * Get dtTesellumObjId value
     * @return \fk_\StructType\DtTesellumObjId|null
     */
    public function getDtTesellumObjId()
    {
        return $this->dtTesellumObjId;
    }
    /**
     * Set dtTesellumObjId value
     * @param \fk_\StructType\DtTesellumObjId $dtTesellumObjId
     * @return \fk_\StructType\KFatura
     */
    public function setDtTesellumObjId(\fk_\StructType\DtTesellumObjId $dtTesellumObjId = null)
    {
        $this->dtTesellumObjId = $dtTesellumObjId;
        return $this;
    }
    /**
     * Get TevkifEdilenKDV value
     * @return \fk_\StructType\DovizliTutar|null
     */
    public function getTevkifEdilenKDV()
    {
        return $this->TevkifEdilenKDV;
    }
    /**
     * Set TevkifEdilenKDV value
     * @param \fk_\StructType\DovizliTutar $tevkifEdilenKDV
     * @return \fk_\StructType\KFatura
     */
    public function setTevkifEdilenKDV(\fk_\StructType\DovizliTutar $tevkifEdilenKDV = null)
    {
        $this->TevkifEdilenKDV = $tevkifEdilenKDV;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KFatura
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
