<?php

namespace fk_\EnumType;

/**
 * This class stands for KargodanGeldimi EnumType
 * @subpackage Enumerations
 */
class KargodanGeldimi
{
    /**
     * Constant for value 'Gelmedi'
     * @return string 'Gelmedi'
     */
    const VALUE_GELMEDI = 'Gelmedi';
    /**
     * Constant for value 'Geldi'
     * @return string 'Geldi'
     */
    const VALUE_GELDI = 'Geldi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GELMEDI
     * @uses self::VALUE_GELDI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GELMEDI,
            self::VALUE_GELDI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
