<?php

namespace fk_\EnumType;

/**
 * This class stands for KEKTuru EnumType
 * @subpackage Enumerations
 */
class KEKTuru
{
    /**
     * Constant for value 'OtomatikKek'
     * @return string 'OtomatikKek'
     */
    const VALUE_OTOMATIK_KEK = 'OtomatikKek';
    /**
     * Constant for value 'ManuelKek'
     * @return string 'ManuelKek'
     */
    const VALUE_MANUEL_KEK = 'ManuelKek';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTOMATIK_KEK
     * @uses self::VALUE_MANUEL_KEK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTOMATIK_KEK,
            self::VALUE_MANUEL_KEK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
