<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KVardiya StructType
 * @subpackage Structs
 */
class KVardiya extends Entity
{
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ad;
    /**
     * The BasSaat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BasSaat;
    /**
     * The BitSaat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BitSaat;
    /**
     * The CumBasSaat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CumBasSaat;
    /**
     * The CumBitSaat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CumBitSaat;
    /**
     * The PazBasSaat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PazBasSaat;
    /**
     * The PazBitSaat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PazBitSaat;
    /**
     * Constructor method for KVardiya
     * @uses KVardiya::setAd()
     * @uses KVardiya::setBasSaat()
     * @uses KVardiya::setBitSaat()
     * @uses KVardiya::setCumBasSaat()
     * @uses KVardiya::setCumBitSaat()
     * @uses KVardiya::setPazBasSaat()
     * @uses KVardiya::setPazBitSaat()
     * @param string $ad
     * @param string $basSaat
     * @param string $bitSaat
     * @param string $cumBasSaat
     * @param string $cumBitSaat
     * @param string $pazBasSaat
     * @param string $pazBitSaat
     */
    public function __construct($ad = null, $basSaat = null, $bitSaat = null, $cumBasSaat = null, $cumBitSaat = null, $pazBasSaat = null, $pazBitSaat = null)
    {
        $this
            ->setAd($ad)
            ->setBasSaat($basSaat)
            ->setBitSaat($bitSaat)
            ->setCumBasSaat($cumBasSaat)
            ->setCumBitSaat($cumBitSaat)
            ->setPazBasSaat($pazBasSaat)
            ->setPazBitSaat($pazBitSaat);
    }
    /**
     * Get Ad value
     * @return string|null
     */
    public function getAd()
    {
        return $this->Ad;
    }
    /**
     * Set Ad value
     * @param string $ad
     * @return \fk_\StructType\KVardiya
     */
    public function setAd($ad = null)
    {
        // validation for constraint: string
        if (!is_null($ad) && !is_string($ad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad, true), gettype($ad)), __LINE__);
        }
        $this->Ad = $ad;
        return $this;
    }
    /**
     * Get BasSaat value
     * @return string|null
     */
    public function getBasSaat()
    {
        return $this->BasSaat;
    }
    /**
     * Set BasSaat value
     * @param string $basSaat
     * @return \fk_\StructType\KVardiya
     */
    public function setBasSaat($basSaat = null)
    {
        // validation for constraint: string
        if (!is_null($basSaat) && !is_string($basSaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basSaat, true), gettype($basSaat)), __LINE__);
        }
        $this->BasSaat = $basSaat;
        return $this;
    }
    /**
     * Get BitSaat value
     * @return string|null
     */
    public function getBitSaat()
    {
        return $this->BitSaat;
    }
    /**
     * Set BitSaat value
     * @param string $bitSaat
     * @return \fk_\StructType\KVardiya
     */
    public function setBitSaat($bitSaat = null)
    {
        // validation for constraint: string
        if (!is_null($bitSaat) && !is_string($bitSaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitSaat, true), gettype($bitSaat)), __LINE__);
        }
        $this->BitSaat = $bitSaat;
        return $this;
    }
    /**
     * Get CumBasSaat value
     * @return string|null
     */
    public function getCumBasSaat()
    {
        return $this->CumBasSaat;
    }
    /**
     * Set CumBasSaat value
     * @param string $cumBasSaat
     * @return \fk_\StructType\KVardiya
     */
    public function setCumBasSaat($cumBasSaat = null)
    {
        // validation for constraint: string
        if (!is_null($cumBasSaat) && !is_string($cumBasSaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cumBasSaat, true), gettype($cumBasSaat)), __LINE__);
        }
        $this->CumBasSaat = $cumBasSaat;
        return $this;
    }
    /**
     * Get CumBitSaat value
     * @return string|null
     */
    public function getCumBitSaat()
    {
        return $this->CumBitSaat;
    }
    /**
     * Set CumBitSaat value
     * @param string $cumBitSaat
     * @return \fk_\StructType\KVardiya
     */
    public function setCumBitSaat($cumBitSaat = null)
    {
        // validation for constraint: string
        if (!is_null($cumBitSaat) && !is_string($cumBitSaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cumBitSaat, true), gettype($cumBitSaat)), __LINE__);
        }
        $this->CumBitSaat = $cumBitSaat;
        return $this;
    }
    /**
     * Get PazBasSaat value
     * @return string|null
     */
    public function getPazBasSaat()
    {
        return $this->PazBasSaat;
    }
    /**
     * Set PazBasSaat value
     * @param string $pazBasSaat
     * @return \fk_\StructType\KVardiya
     */
    public function setPazBasSaat($pazBasSaat = null)
    {
        // validation for constraint: string
        if (!is_null($pazBasSaat) && !is_string($pazBasSaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pazBasSaat, true), gettype($pazBasSaat)), __LINE__);
        }
        $this->PazBasSaat = $pazBasSaat;
        return $this;
    }
    /**
     * Get PazBitSaat value
     * @return string|null
     */
    public function getPazBitSaat()
    {
        return $this->PazBitSaat;
    }
    /**
     * Set PazBitSaat value
     * @param string $pazBitSaat
     * @return \fk_\StructType\KVardiya
     */
    public function setPazBitSaat($pazBitSaat = null)
    {
        // validation for constraint: string
        if (!is_null($pazBitSaat) && !is_string($pazBitSaat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pazBitSaat, true), gettype($pazBitSaat)), __LINE__);
        }
        $this->PazBitSaat = $pazBitSaat;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KVardiya
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
